/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-12-23 05:06:53 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `moyhd_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=872 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=23948 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2686 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `owner` varchar(60) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_email_forgot` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_notifications` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `description` mediumtext DEFAULT NULL,
  `user_type` int(1) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_notifications_read` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `notification_id` mediumtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_sidemenu` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `setting_id` int(9) DEFAULT 1,
  `items` mediumtext DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `all_settings` mediumtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_sms_providers` (
  `id` int(11) NOT NULL,
  `provider` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `reset_password_pattern` varchar(255) DEFAULT NULL,
  `type` int(1) NOT NULL DEFAULT 0,
  `number` varchar(255) NOT NULL,
  `is_default` int(1) NOT NULL DEFAULT 0,
  `sms_time_check` int(1) NOT NULL DEFAULT 5,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `ordering` int(2) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_sms_provider_name` (
  `id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `className` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_hd_upanel_tickets` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `ticket_text` longtext DEFAULT NULL,
  `ticket_priority` int(11) DEFAULT NULL,
  `ticket_status` int(11) DEFAULT 0,
  `checked` int(1) DEFAULT 0,
  `parent` int(11) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `department_color` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ticket_type` varchar(255) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_imagify_files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `folder_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `file_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(191) NOT NULL DEFAULT '',
  `hash` varchar(32) NOT NULL DEFAULT '',
  `mime_type` varchar(100) NOT NULL DEFAULT '',
  `modified` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `width` smallint(2) unsigned NOT NULL DEFAULT 0,
  `height` smallint(2) unsigned NOT NULL DEFAULT 0,
  `original_size` int(4) unsigned NOT NULL DEFAULT 0,
  `optimized_size` int(4) unsigned DEFAULT NULL,
  `percent` smallint(2) unsigned DEFAULT NULL,
  `optimization_level` tinyint(1) unsigned DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `error` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `path` (`path`),
  KEY `folder_id` (`folder_id`),
  KEY `optimization_level` (`optimization_level`),
  KEY `status` (`status`),
  KEY `modified` (`modified`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_imagify_folders` (
  `folder_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(191) NOT NULL DEFAULT '',
  `active` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`folder_id`),
  UNIQUE KEY `path` (`path`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_oping_backups` (
  `oping_backup_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `creator_user_id` bigint(20) NOT NULL,
  `service_type` int(2) NOT NULL,
  `backup_url` text DEFAULT NULL,
  `backup_path` text DEFAULT NULL,
  `status` int(2) NOT NULL,
  `message` text DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `date_modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`oping_backup_id`),
  KEY `creator_user_id` (`creator_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_oping_backup_services` (
  `oping_backup_service_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `creator_user_id` bigint(20) NOT NULL,
  `service_name` varchar(400) NOT NULL,
  `service_type` int(2) NOT NULL,
  `data` text NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `date_modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`oping_backup_service_id`),
  KEY `creator_user_id` (`creator_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=45904 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=50009 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=22300 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `moyhd_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_snippets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `description` text NOT NULL,
  `code` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `scope` varchar(15) NOT NULL DEFAULT 'global',
  `priority` smallint(6) NOT NULL DEFAULT 10,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT current_timestamp(),
  `revision` bigint(20) NOT NULL DEFAULT 1,
  `cloud_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=368 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text NOT NULL,
  `text2` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_ir_sms_archive` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` mediumint(8) unsigned DEFAULT NULL,
  `type` tinyint(2) DEFAULT NULL,
  `reciever` text NOT NULL,
  `message` text NOT NULL,
  `sender` varchar(100) DEFAULT NULL,
  `result` text DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_ir_sms_contacts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` mediumint(8) unsigned DEFAULT NULL,
  `mobile` varchar(250) DEFAULT NULL,
  `groups` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=20712 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `moyhd_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `moyhd_users` VALUES 
("1","GTAall","$P$BFFFisDOZvDoGjTxknJ56lJdjh0Yai1","dachweb_admin-2","support@gtaall.ir","https://wantedrp.ir","2024-06-21 13:50:23","","0","SignorCrazy");

INSERT IGNORE INTO `moyhd_usermeta` VALUES 
("1","1","nickname","SignorCrzy"),
("2","1","first_name","محمد"),
("3","1","last_name","مسعود"),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","moyhd_capabilities","a:2:{s:13:\"administrator\";b:1;s:9:\"hd_access\";b:1;}"),
("13","1","moyhd_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","moyhd_dashboard_quick_press_last_post_id","22209"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:13:\"185.199.211.0\";}"),
("19","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:60:\"dashboard_site_health,dashboard_right_now,dashboard_activity\";s:4:\"side\";s:42:\"dashboard_quick_press,e-dashboard-overview\";s:7:\"column3\";s:42:\"dashboard_primary,wc_admin_dashboard_setup\";s:7:\"column4\";s:0:\"\";}"),
("20","1","closedpostboxes_dashboard","a:1:{i:0;s:24:\"persian_woocommerce_feed\";}"),
("21","1","metaboxhidden_dashboard","a:8:{i:0;s:21:\"dashboard_site_health\";i:1;s:19:\"dashboard_right_now\";i:2;s:18:\"dashboard_activity\";i:3;s:24:\"persian_woocommerce_feed\";i:4;s:28:\"woocommerce_dashboard_status\";i:5;s:21:\"dashboard_quick_press\";i:6;s:20:\"e-dashboard-overview\";i:7;s:17:\"dashboard_primary\";}"),
("22","1","wc_last_active","1734825600"),
("23","1","_woocommerce_tracks_anon_id","woo:c4xD1jDO6MuLB6oBPydCvu1k"),
("24","1","mwfc_pro_version_dismissed","true"),
("25","1","mwfc_pro_version_2_dismissed","true"),
("26","1","moyhd_user-settings","editor=tinymce&hidetb=1&libraryContent=browse&advImgDetails=hide"),
("27","1","moyhd_user-settings-time","1734851255"),
("28","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("29","1","nav_menu_recently_edited","49"),
("30","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("31","1","metaboxhidden_nav-menus","a:9:{i:0;s:23:\"add-post-type-portfolio\";i:1;s:31:\"add-post-type-codevz_size_guide\";i:2;s:24:\"add-post-type-codevz_faq\";i:3;s:21:\"add-post-type-product\";i:4;s:12:\"add-post_tag\";i:5;s:15:\"add-post_format\";i:6;s:18:\"add-portfolio_tags\";i:7;s:17:\"add-codevz_brands\";i:8;s:15:\"add-product_tag\";}"),
("32","1","elementor_introduction","a:5:{s:27:\"ai-get-started-announcement\";b:1;s:7:\"exit_to\";b:1;s:20:\"globals_introduction\";b:1;s:35:\"ai_promotion_introduction_container\";b:1;s:30:\"e-ai-product-image-unification\";b:1;}"),
("33","1","closedpostboxes_post","a:0:{}"),
("34","1","metaboxhidden_post","a:6:{i:0;s:13:\"trackbacksdiv\";i:1;s:10:\"postcustom\";i:2;s:16:\"commentstatusdiv\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}"),
("35","1","closedpostboxes_nav-menus","a:0:{}"),
("36","1","image_optimizer_dismissed_pointers","a:1:{s:24:\"image-optimizer-settings\";b:1;}"),
("37","1","_imagify_ignore_notices","a:2:{i:0;s:13:\"wrong-api-key\";i:1;s:6:\"rating\";}"),
("38","1","billing_first_name",""),
("39","1","billing_last_name",""),
("40","1","billing_company",""),
("41","1","billing_address_1",""),
("42","1","billing_address_2",""),
("43","1","billing_city",""),
("44","1","billing_postcode",""),
("45","1","billing_country",""),
("46","1","billing_state",""),
("47","1","billing_phone",""),
("48","1","billing_email","support@gtaall.ir"),
("49","1","shipping_first_name",""),
("50","1","shipping_last_name",""),
("51","1","shipping_company",""),
("52","1","shipping_address_1",""),
("53","1","shipping_address_2",""),
("54","1","shipping_city",""),
("55","1","shipping_postcode",""),
("56","1","shipping_country",""),
("57","1","shipping_state",""),
("58","1","shipping_phone",""),
("59","1","last_update","1730174741"),
("60","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("61","1","woocommerce_admin_task_list_tracked_started_tasks","{\"customize-store\":1}"),
("62","1","woocommerce_admin_homepage_stats","{\"hiddenStats\":[\"revenue/net_revenue\",\"products/items_sold\",\"revenue/total_sales\",\"orders/orders_count\"],\"installJetpackDismissed\":true}"),
("63","1","meta-box-order_toplevel_page_aiowpsec","a:4:{s:6:\"normal\";s:55:\"spread_the_word,know_developers,last_5_logins,smart_404\";s:4:\"side\";s:95:\"critical_feature_status,maintenance_mode_status,locked_ip_addresses,logged_in_users,brute_force\";s:7:\"column3\";s:49:\"security_strength_meter,security_points_breakdown\";s:7:\"column4\";s:0:\"\";}"),
("64","1","closedpostboxes_toplevel_page_aiowpsec","a:0:{}"),
("65","1","metaboxhidden_toplevel_page_aiowpsec","a:0:{}"),
("66","1","elementor_admin_notices","a:5:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.25.1\";}}s:25:\"plugin_image_optimization\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:31:\"elementor-pro-forms-submissions\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:21:\"site_mailer_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("67","1","thwcfd_review_skipped","1"),
("68","1","thwcfd_review_skipped_time","1719681442"),
("77","1","moyhd_media_library_mode","list"),
("83","1","thwcfd_review_dismissed","1"),
("84","1","thwcfd_review_dismissed_time","1720292913"),
("102","1","dismissed_update_notice","1"),
("103","1","woocommerce_admin_variable_product_tour_shown","\"yes\""),
("108","1","dismissed_redirect_download_method_notice","1"),
("109","1","elementor_dismissed_editor_notices","a:1:{i:0;s:20:\"image_optimizer_hint\";}"),
("110","1","closedpostboxes_product","a:1:{i:0;s:19:\"codevz_woo_meta_box\";}"),
("111","1","metaboxhidden_product","a:2:{i:0;s:11:\"postdivrich\";i:2;s:7:\"slugdiv\";}"),
("132","1","edit_post_per_page","999"),
("133","1","moyhd_elementor_enable_ai","1"),
("139","1","tfa_priv_key_64","SgkxZUPcdYzZyq5JqfTpXgoo5NWIbPy9iXZOOERPYb8="),
("140","1","simba_tfa_emergency_codes_64","a:3:{i:0;s:44:\"rlFRQHlGe1lAX0yMlaWeOuMkigc2LDvDgbPWB35iL9Y=\";i:1;s:44:\"IppH8VfulQmPtEedP5Cs3wvgMW2Z6cLfZwg6nziObzo=\";i:2;s:44:\"ZCcqw00env/v2+xvmQ9zNOEIUNWGstC1BUb4QkKJQUo=\";}"),
("141","1","tfa_algorithm_type","totp"),
("143","1","wc_money_spent_moyhd","0"),
("150","1","edit_category_per_page","900"),
("151","1","moyhd_elementor_pro_enable_notes_notifications","1"),
("152","1","custom_avatar","http://localhost/wp-content/uploads/2024/12/prof.jpg"),
("153","1","simple_local_avatar","a:12:{s:8:\"media_id\";i:22298;s:4:\"full\";s:62:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1.jpg\";s:7:\"blog_id\";i:1;i:192;s:70:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-192x192.jpg\";i:96;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-96x96.jpg\";i:128;s:70:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-128x128.jpg\";i:64;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-64x64.jpg\";i:52;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-52x52.jpg\";i:26;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-26x26.jpg\";i:24;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-24x24.jpg\";i:48;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-48x48.jpg\";i:32;s:68:\"http://localhost/wp-content/uploads/2024/12/cropped-prof-1-32x32.jpg\";}"),
("154","1","simple_local_avatar_rating","G"),
("155","1","ignore_code_snippets_survey_message","pro"),
("156","1","session_tokens","a:2:{s:64:\"6078cf43755908c0641ace0e371df64adca229498b60fc415ac5047414fd3173\";a:4:{s:10:\"expiration\";i:1735033715;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0\";s:5:\"login\";i:1734860915;}s:64:\"71abc7cab67a27f1f3b81a2cdb45ee39557ed09b62542d8d09176a6f2fdc30b0\";a:4:{s:10:\"expiration\";i:1735102572;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 OPR/114.0.0.0\";s:5:\"login\";i:1734929772;}}"),
("157","1","ignore_code_snippets_survey_message","survey");

INSERT IGNORE INTO `moyhd_actionscheduler_actions` VALUES 
("14","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2024-06-21 13:58:51","2024-06-21 13:58:51","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2024-06-21 13:59:05","2024-06-21 14:59:05","0",NULL),
("16","action_scheduler/migration_hook","failed","2024-06-21 14:07:08","2024-06-21 15:07:08","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1718978828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1718978828;}","1","1","2024-06-21 14:07:17","2024-06-21 15:07:17","0",NULL),
("18","action_scheduler/migration_hook","failed","2024-06-21 14:20:14","2024-06-21 15:20:14","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1718979614;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1718979614;}","1","1","2024-06-21 14:20:17","2024-06-21 15:20:17","0",NULL),
("48","action_scheduler/migration_hook","failed","2024-06-22 09:18:49","2024-06-22 10:18:49","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1719047929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1719047929;}","1","1","2024-06-22 09:19:02","2024-06-22 10:19:02","0",NULL),
("103","action_scheduler/migration_hook","failed","2024-06-22 10:12:25","2024-06-22 11:12:25","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1719051145;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1719051145;}","1","1","2024-06-22 10:13:27","2024-06-22 11:13:27","0",NULL),
("117","action_scheduler/migration_hook","failed","2024-06-28 09:58:09","2024-06-28 10:58:09","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1719568689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1719568689;}","1","1","2024-06-28 09:58:09","2024-06-28 10:58:09","0",NULL),
("301","action_scheduler/migration_hook","failed","2024-09-15 08:13:31","2024-09-15 12:43:31","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726388011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726388011;}","1","1","2024-09-15 08:13:53","2024-09-15 12:43:53","0",NULL),
("426","woocommerce_cleanup_draft_orders","complete","2024-11-22 19:23:05","2024-11-22 22:53:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732303385;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732303385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-22 20:50:47","2024-11-23 00:20:47","0",NULL),
("427","woocommerce_cleanup_draft_orders","complete","2024-11-22 19:23:05","2024-11-22 22:53:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732303385;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732303385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-22 20:50:47","2024-11-23 00:20:47","0",NULL),
("428","woocommerce_cleanup_draft_orders","complete","2024-11-23 20:50:47","2024-11-24 00:20:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732395047;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732395047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-23 20:53:54","2024-11-24 00:23:54","0",NULL),
("429","woocommerce_cleanup_draft_orders","complete","2024-11-23 20:50:47","2024-11-24 00:20:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732395047;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732395047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-23 20:53:54","2024-11-24 00:23:54","0",NULL),
("430","woocommerce_cleanup_draft_orders","complete","2024-11-24 20:53:54","2024-11-25 00:23:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732481634;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732481634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-24 20:53:54","2024-11-25 00:23:54","0",NULL),
("431","woocommerce_cleanup_draft_orders","complete","2024-11-24 20:53:54","2024-11-25 00:23:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732481634;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732481634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-24 20:53:54","2024-11-25 00:23:54","0",NULL),
("432","woocommerce_cleanup_draft_orders","complete","2024-11-25 20:53:54","2024-11-26 00:23:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732568034;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732568034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-25 22:42:05","2024-11-26 02:12:05","0",NULL),
("433","woocommerce_cleanup_draft_orders","complete","2024-11-25 20:53:54","2024-11-26 00:23:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732568034;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732568034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-25 22:42:05","2024-11-26 02:12:05","0",NULL),
("434","woocommerce_cleanup_draft_orders","complete","2024-11-26 22:42:05","2024-11-27 02:12:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732660925;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732660925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-26 22:59:35","2024-11-27 02:29:35","0",NULL),
("435","woocommerce_cleanup_draft_orders","complete","2024-11-26 22:42:05","2024-11-27 02:12:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732660925;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732660925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-26 22:59:35","2024-11-27 02:29:35","0",NULL),
("436","woocommerce_cleanup_draft_orders","complete","2024-11-27 22:59:35","2024-11-28 02:29:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732748375;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732748375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-27 23:18:12","2024-11-28 02:48:12","0",NULL),
("437","woocommerce_cleanup_draft_orders","complete","2024-11-27 22:59:35","2024-11-28 02:29:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732748375;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732748375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-27 23:18:12","2024-11-28 02:48:12","0",NULL),
("438","woocommerce_cleanup_draft_orders","complete","2024-11-28 23:18:12","2024-11-29 02:48:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732835892;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732835892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-28 23:28:39","2024-11-29 02:58:39","0",NULL),
("439","woocommerce_cleanup_draft_orders","complete","2024-11-28 23:18:12","2024-11-29 02:48:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732835892;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732835892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-28 23:28:39","2024-11-29 02:58:39","0",NULL),
("440","woocommerce_cleanup_draft_orders","complete","2024-11-29 23:28:39","2024-11-30 02:58:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732922919;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732922919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-29 23:37:59","2024-11-30 03:07:59","0",NULL),
("441","woocommerce_cleanup_draft_orders","complete","2024-11-29 23:28:39","2024-11-30 02:58:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732922919;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732922919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-29 23:37:59","2024-11-30 03:07:59","0",NULL),
("442","woocommerce_cleanup_draft_orders","complete","2024-11-30 23:37:59","2024-12-01 03:07:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733009879;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733009879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-30 23:57:03","2024-12-01 03:27:03","0",NULL),
("443","woocommerce_cleanup_draft_orders","complete","2024-11-30 23:37:59","2024-12-01 03:07:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733009879;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733009879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-11-30 23:57:03","2024-12-01 03:27:03","0",NULL),
("444","woocommerce_cleanup_draft_orders","complete","2024-12-01 23:57:03","2024-12-02 03:27:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733097423;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733097423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-02 00:10:20","2024-12-02 03:40:20","0",NULL),
("445","woocommerce_cleanup_draft_orders","complete","2024-12-01 23:57:03","2024-12-02 03:27:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733097423;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733097423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-02 00:10:20","2024-12-02 03:40:20","0",NULL),
("446","woocommerce_cleanup_draft_orders","complete","2024-12-03 00:10:20","2024-12-03 03:40:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733184620;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733184620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-03 00:28:32","2024-12-03 03:58:32","0",NULL),
("447","woocommerce_cleanup_draft_orders","complete","2024-12-03 00:10:20","2024-12-03 03:40:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733184620;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733184620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-03 00:28:32","2024-12-03 03:58:32","0",NULL),
("448","woocommerce_cleanup_draft_orders","complete","2024-12-04 00:28:32","2024-12-04 03:58:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733272112;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733272112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-04 00:30:21","2024-12-04 04:00:21","0",NULL),
("449","woocommerce_cleanup_draft_orders","complete","2024-12-04 00:28:32","2024-12-04 03:58:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733272112;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733272112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-04 00:30:21","2024-12-04 04:00:21","0",NULL),
("450","woocommerce_cleanup_draft_orders","complete","2024-12-05 00:30:21","2024-12-05 04:00:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733358621;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733358621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-05 01:41:28","2024-12-05 05:11:28","0",NULL),
("451","woocommerce_cleanup_draft_orders","complete","2024-12-05 00:30:21","2024-12-05 04:00:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733358621;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733358621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-05 01:41:28","2024-12-05 05:11:28","0",NULL),
("452","woocommerce_run_on_woocommerce_admin_updated","complete","2024-12-04 02:17:01","2024-12-04 05:47:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733278621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733278621;}","8","1","2024-12-04 02:17:30","2024-12-04 05:47:30","0",NULL),
("453","woocommerce_cleanup_draft_orders","complete","2024-12-06 01:41:28","2024-12-06 05:11:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733449288;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733449288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-06 01:55:49","2024-12-06 05:25:49","0",NULL),
("454","woocommerce_cleanup_draft_orders","complete","2024-12-06 01:41:28","2024-12-06 05:11:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733449288;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733449288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-06 01:55:49","2024-12-06 05:25:49","0",NULL),
("455","woocommerce_cleanup_draft_orders","complete","2024-12-07 01:55:49","2024-12-07 05:25:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733536549;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733536549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-07 02:16:45","2024-12-07 05:46:45","0",NULL),
("456","woocommerce_cleanup_draft_orders","complete","2024-12-07 01:55:49","2024-12-07 05:25:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733536549;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733536549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-07 02:16:45","2024-12-07 05:46:45","0",NULL),
("457","woocommerce_cleanup_draft_orders","complete","2024-12-08 02:16:45","2024-12-08 05:46:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733624205;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733624205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-08 02:18:26","2024-12-08 05:48:26","0",NULL),
("458","woocommerce_cleanup_draft_orders","complete","2024-12-08 02:16:45","2024-12-08 05:46:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733624205;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733624205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-08 02:18:26","2024-12-08 05:48:26","0",NULL),
("459","woocommerce_cleanup_draft_orders","complete","2024-12-09 02:18:26","2024-12-09 05:48:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733710706;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733710706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-09 02:21:46","2024-12-09 05:51:46","0",NULL),
("460","woocommerce_cleanup_draft_orders","complete","2024-12-09 02:18:26","2024-12-09 05:48:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733710706;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733710706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-09 02:21:46","2024-12-09 05:51:46","0",NULL),
("461","woocommerce_cleanup_draft_orders","complete","2024-12-10 02:21:46","2024-12-10 05:51:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733797306;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733797306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-10 02:36:59","2024-12-10 06:06:59","0",NULL),
("462","woocommerce_cleanup_draft_orders","complete","2024-12-10 02:21:46","2024-12-10 05:51:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733797306;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733797306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-10 02:36:59","2024-12-10 06:06:59","0",NULL),
("463","woocommerce_cleanup_draft_orders","complete","2024-12-11 02:36:59","2024-12-11 06:06:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733884619;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733884619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-11 02:47:34","2024-12-11 06:17:34","0",NULL),
("464","woocommerce_cleanup_draft_orders","complete","2024-12-11 02:36:59","2024-12-11 06:06:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733884619;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733884619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-11 02:47:34","2024-12-11 06:17:34","0",NULL),
("465","woocommerce_cleanup_draft_orders","complete","2024-12-12 02:47:34","2024-12-12 06:17:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733971654;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733971654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-12 03:11:29","2024-12-12 06:41:29","0",NULL),
("466","woocommerce_cleanup_draft_orders","complete","2024-12-12 02:47:34","2024-12-12 06:17:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733971654;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733971654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-12 03:11:29","2024-12-12 06:41:29","0",NULL),
("467","woocommerce_cleanup_draft_orders","complete","2024-12-13 03:11:29","2024-12-13 06:41:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734059489;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734059489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-13 03:11:42","2024-12-13 06:41:42","0",NULL),
("468","woocommerce_cleanup_draft_orders","complete","2024-12-13 03:11:29","2024-12-13 06:41:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734059489;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734059489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-13 03:11:42","2024-12-13 06:41:42","0",NULL),
("469","woocommerce_cleanup_draft_orders","complete","2024-12-14 03:11:42","2024-12-14 06:41:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734145902;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734145902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-14 07:41:15","2024-12-14 11:11:15","0",NULL),
("470","woocommerce_cleanup_draft_orders","complete","2024-12-14 03:11:42","2024-12-14 06:41:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734145902;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734145902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-14 07:41:15","2024-12-14 11:11:15","0",NULL),
("471","woocommerce_cleanup_draft_orders","complete","2024-12-15 07:41:15","2024-12-15 11:11:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734248475;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734248475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-15 07:41:26","2024-12-15 11:11:26","0",NULL),
("472","woocommerce_cleanup_draft_orders","complete","2024-12-15 07:41:15","2024-12-15 11:11:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734248475;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734248475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-15 07:41:26","2024-12-15 11:11:26","0",NULL),
("473","woocommerce_cleanup_draft_orders","complete","2024-12-16 07:41:26","2024-12-16 11:11:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734334886;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734334886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-16 07:44:18","2024-12-16 11:14:18","0",NULL),
("474","woocommerce_cleanup_draft_orders","complete","2024-12-16 07:41:26","2024-12-16 11:11:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734334886;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734334886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-16 07:44:18","2024-12-16 11:14:18","0",NULL),
("475","woocommerce_cleanup_draft_orders","complete","2024-12-17 07:44:18","2024-12-17 11:14:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734421458;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734421458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-17 08:19:10","2024-12-17 11:49:10","0",NULL),
("476","woocommerce_cleanup_draft_orders","complete","2024-12-17 07:44:18","2024-12-17 11:14:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734421458;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734421458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-17 08:19:10","2024-12-17 11:49:10","0",NULL),
("477","woocommerce_cleanup_draft_orders","complete","2024-12-18 08:19:10","2024-12-18 11:49:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734509950;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734509950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-18 08:26:29","2024-12-18 11:56:29","0",NULL),
("478","woocommerce_cleanup_draft_orders","complete","2024-12-18 08:19:10","2024-12-18 11:49:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734509950;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734509950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-18 08:26:30","2024-12-18 11:56:30","0",NULL),
("479","woocommerce_run_on_woocommerce_admin_updated","complete","2024-12-18 01:52:01","2024-12-18 05:22:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734486721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734486721;}","8","1","2024-12-18 01:52:24","2024-12-18 05:22:24","0",NULL),
("480","woocommerce_cleanup_draft_orders","complete","2024-12-19 08:26:29","2024-12-19 11:56:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734596789;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734596789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-19 08:47:39","2024-12-19 12:17:39","0",NULL),
("481","woocommerce_cleanup_draft_orders","complete","2024-12-19 08:26:30","2024-12-19 11:56:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734596790;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734596790;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-19 08:47:39","2024-12-19 12:17:39","0",NULL),
("482","woocommerce_run_update_callback","complete","2024-12-19 05:20:58","2024-12-19 08:50:58","10","{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734585658;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734585658;}","4","1","2024-12-19 05:21:17","2024-12-19 08:51:17","0",NULL),
("483","woocommerce_run_update_callback","complete","2024-12-19 05:20:59","2024-12-19 08:50:59","10","{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734585659;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734585659;}","4","1","2024-12-19 05:21:17","2024-12-19 08:51:17","0",NULL),
("484","woocommerce_run_update_callback","complete","2024-12-19 05:21:00","2024-12-19 08:51:00","10","{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734585660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734585660;}","4","1","2024-12-19 05:21:17","2024-12-19 08:51:17","0",NULL),
("485","woocommerce_update_db_to_current_version","complete","2024-12-19 05:21:01","2024-12-19 08:51:01","10","{\"version\":\"9.5.1\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734585661;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734585661;}","4","1","2024-12-19 05:21:17","2024-12-19 08:51:17","0",NULL),
("486","woocommerce_cleanup_draft_orders","complete","2024-12-20 08:47:39","2024-12-20 12:17:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734684459;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734684459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-20 09:15:15","2024-12-20 12:45:15","0",NULL),
("487","woocommerce_cleanup_draft_orders","complete","2024-12-20 08:47:39","2024-12-20 12:17:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734684459;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734684459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-20 09:15:16","2024-12-20 12:45:16","0",NULL),
("488","woocommerce_cleanup_draft_orders","complete","2024-12-21 09:15:15","2024-12-21 12:45:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734772515;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734772515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-21 09:28:54","2024-12-21 12:58:54","0",NULL),
("489","woocommerce_cleanup_draft_orders","complete","2024-12-21 09:15:16","2024-12-21 12:45:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734772516;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734772516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-21 09:28:54","2024-12-21 12:58:54","0",NULL),
("491","rocket_job_warmup","complete","2024-12-20 21:26:59","2024-12-20 21:26:59","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:17","2024-12-21 00:58:17","0",NULL),
("493","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/shop\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:28","2024-12-21 00:58:28","0",NULL),
("494","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/other\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:28","2024-12-21 00:58:28","0",NULL),
("495","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:28","2024-12-21 00:58:28","0",NULL),
("496","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\\/skins\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:29","2024-12-21 00:58:29","0",NULL),
("497","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:29","2024-12-21 00:58:29","0",NULL),
("498","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/money\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:29","2024-12-21 00:58:29","0",NULL),
("499","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/diamond\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:29","2024-12-21 00:58:29","0",NULL),
("500","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:30","2024-12-21 00:58:30","0",NULL),
("501","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/gang\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:30","2024-12-21 00:58:30","0",NULL),
("502","rocket_job_warmup_url","complete","2024-12-20 21:28:17","2024-12-20 21:28:17","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/cartel\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:28:30","2024-12-21 00:58:30","0",NULL),
("533","rocket_job_warmup","complete","2024-12-20 21:38:20","2024-12-20 21:38:20","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:54:10","2024-12-21 01:24:10","0",NULL),
("573","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/shop\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:21","2024-12-21 01:27:21","0",NULL),
("574","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/other\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:22","2024-12-21 01:27:22","0",NULL),
("575","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:23","2024-12-21 01:27:23","0",NULL),
("576","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\\/skins\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:23","2024-12-21 01:27:23","0",NULL),
("577","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:24","2024-12-21 01:27:24","0",NULL),
("578","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/money\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:25","2024-12-21 01:27:25","0",NULL),
("579","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/diamond\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:25","2024-12-21 01:27:25","0",NULL),
("580","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:26","2024-12-21 01:27:26","0",NULL),
("581","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/gang\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:27","2024-12-21 01:27:27","0",NULL),
("582","rocket_job_warmup_url","complete","2024-12-20 21:54:10","2024-12-20 21:54:10","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/cartel\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-20 21:57:27","2024-12-21 01:27:27","0",NULL),
("654","woocommerce_run_product_attribute_lookup_update_callback","complete","2024-12-21 07:26:32","2024-12-21 10:56:32","10","[1739,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734765992;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734765992;}","4","1","2024-12-21 07:32:25","2024-12-21 11:02:25","0",NULL),
("708","woocommerce_run_product_attribute_lookup_update_callback","complete","2024-12-21 07:38:33","2024-12-21 11:08:33","10","[1739,1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734766713;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734766713;}","4","1","2024-12-21 07:50:15","2024-12-21 11:20:15","23651",NULL),
("728","woocommerce_cleanup_draft_orders","failed","2024-12-22 09:28:54","2024-12-22 12:58:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734859734;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734859734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-22 09:29:05","2024-12-22 12:59:05","0",NULL),
("729","woocommerce_cleanup_draft_orders","failed","2024-12-22 09:28:54","2024-12-22 12:58:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734859734;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734859734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2024-12-22 09:29:05","2024-12-22 12:59:05","0",NULL),
("730","action_scheduler/migration_hook","complete","2024-12-21 11:26:50","2024-12-21 14:56:50","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734780410;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734780410;}","1","1","2024-12-21 11:27:59","2024-12-21 14:57:59","0",NULL),
("758","rocket_preload_job_preload_url","complete","2024-12-21 11:27:28","2024-12-21 11:27:28","10","[\"https:\\/\\/wantedrp.ir\\/wantedrp-fishing\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:11:07","2024-12-22 09:41:07","0",NULL),
("759","rocket_preload_job_preload_url","complete","2024-12-21 11:27:28","2024-12-21 11:27:28","10","[\"https:\\/\\/wantedrp.ir\\/category\\/%D0%BA%D0%BE%D0%BC%D0%B5%D1%82%D0%B0-%D0%BA%D0%B0%D0%B7%D0%B8%D0%BD%D0%BE\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:11:40","2024-12-22 09:41:40","0",NULL),
("760","rocket_preload_job_preload_url","complete","2024-12-21 11:27:28","2024-12-21 11:27:28","10","[\"https:\\/\\/wantedrp.ir\\/category\\/najbolja-zemlja-za-mladenku-za-narude%D1%95bu-poe%D1%9Ete-139\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:11:55","2024-12-22 09:41:55","0",NULL),
("761","rocket_preload_job_preload_url","complete","2024-12-21 11:27:28","2024-12-21 11:27:28","10","[\"https:\\/\\/wantedrp.ir\\/author\\/signorcrazy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:12:15","2024-12-22 09:42:15","0",NULL),
("762","rocket_preload_job_preload_url","complete","2024-12-21 11:27:28","2024-12-21 11:27:28","10","[\"https:\\/\\/wantedrp.ir\\/product\\/gang-rs\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:17","2024-12-22 09:43:17","0",NULL),
("763","rocket_preload_job_preload_url","complete","2024-12-21 11:27:28","2024-12-21 11:27:28","10","[\"https:\\/\\/wantedrp.ir\\/shop\\/page\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:31","2024-12-22 09:43:31","0",NULL),
("764","rocket_preload_job_check_finished","complete","2024-12-21 11:28:59","2024-12-21 14:58:59","10","[1734780479]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734780539;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734780539;}","10","1","2024-12-22 06:13:31","2024-12-22 09:43:31","0",NULL),
("765","action_scheduler/migration_hook","complete","2024-12-21 11:29:02","2024-12-21 14:59:02","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734780542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734780542;}","1","1","2024-12-22 06:13:31","2024-12-22 09:43:31","0",NULL),
("766","rocket_preload_job_preload_url","complete","2024-12-21 11:29:28","2024-12-21 11:29:28","10","[\"https:\\/\\/wantedrp.ir\\/product-tag\\/%D8%B1%D8%B3%D8%AA%D9%88%D8%B1%D8%A7%D9%86\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:34","2024-12-22 09:43:34","0",NULL),
("767","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/shop\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:37","2024-12-22 09:43:37","0",NULL),
("768","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/other\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:40","2024-12-22 09:43:40","0",NULL),
("769","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:43","2024-12-22 09:43:43","0",NULL),
("770","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\\/skins\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:46","2024-12-22 09:43:46","0",NULL),
("771","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:13:57","2024-12-22 09:43:57","0",NULL),
("772","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/money\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:00","2024-12-22 09:44:00","0",NULL),
("773","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/diamond\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:03","2024-12-22 09:44:03","0",NULL),
("774","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:06","2024-12-22 09:44:06","0",NULL),
("775","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/gang\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:09","2024-12-22 09:44:09","0",NULL),
("776","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/mafia\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:12","2024-12-22 09:44:12","0",NULL),
("777","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/blog\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:27","2024-12-22 09:44:27","0",NULL),
("778","rocket_preload_job_preload_url","complete","2024-12-21 11:30:24","2024-12-21 11:30:24","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-rp\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:38","2024-12-22 09:44:38","0",NULL),
("779","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-server\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:42","2024-12-22 09:44:42","0",NULL),
("780","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-jobs\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:45","2024-12-22 09:44:45","0",NULL),
("781","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-factions\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:48","2024-12-22 09:44:48","0",NULL),
("782","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/category\\/send\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:51","2024-12-22 09:44:51","0",NULL),
("783","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/category\\/others\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:14:54","2024-12-22 09:44:54","0",NULL),
("784","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/about\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:04","2024-12-22 09:45:04","0",NULL),
("785","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/contact\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:07","2024-12-22 09:45:07","0",NULL),
("786","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:10","2024-12-22 09:45:10","0",NULL),
("787","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/p-rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:13","2024-12-22 09:45:13","0",NULL),
("788","rocket_preload_job_preload_url","complete","2024-12-21 11:30:25","2024-12-21 11:30:25","10","[\"https:\\/\\/wantedrp.ir\\/c-rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:16","2024-12-22 09:45:16","0",NULL),
("789","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/shop\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:19","2024-12-22 09:45:19","0",NULL),
("790","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/other\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:22","2024-12-22 09:45:22","0",NULL),
("791","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:36","2024-12-22 09:45:36","0",NULL),
("792","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/items\\/skins\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:46","2024-12-22 09:45:46","0",NULL),
("793","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:49","2024-12-22 09:45:49","0",NULL),
("794","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/money\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:52","2024-12-22 09:45:52","0",NULL),
("795","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/game-money\\/diamond\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:55","2024-12-22 09:45:55","0",NULL),
("796","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:15:58","2024-12-22 09:45:58","0",NULL),
("797","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/gang\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:01","2024-12-22 09:46:01","0",NULL),
("798","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/product-category\\/crime\\/mafia\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:04","2024-12-22 09:46:04","0",NULL),
("799","rocket_preload_job_preload_url","complete","2024-12-21 11:36:56","2024-12-21 11:36:56","10","[\"https:\\/\\/wantedrp.ir\\/blog\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:11","2024-12-22 09:46:11","0",NULL),
("800","rocket_preload_job_check_finished","canceled","2024-12-22 06:14:31","2024-12-22 09:44:31","10","[1734848011]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734848071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734848071;}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("801","action_scheduler/migration_hook","failed","2024-12-22 06:14:32","2024-12-22 09:44:32","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734848072;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734848072;}","1","1","2024-12-22 06:17:12","2024-12-22 09:47:12","0",NULL),
("802","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-rp\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:14","2024-12-22 09:46:14","0",NULL),
("803","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-server\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:17","2024-12-22 09:46:17","0",NULL),
("804","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-jobs\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:20","2024-12-22 09:46:20","0",NULL),
("805","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/category\\/learn-factions\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:23","2024-12-22 09:46:23","0",NULL),
("806","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/category\\/send\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:26","2024-12-22 09:46:26","0",NULL),
("807","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/category\\/others\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:29","2024-12-22 09:46:29","0",NULL),
("808","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/about\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:16:58","2024-12-22 09:46:58","0",NULL),
("809","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/contact\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:17:08","2024-12-22 09:47:08","0",NULL),
("810","rocket_preload_job_preload_url","complete","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:17:12","2024-12-22 09:47:12","0",NULL),
("811","rocket_preload_job_preload_url","canceled","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/p-rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("812","rocket_preload_job_preload_url","canceled","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/c-rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("813","rocket_preload_job_preload_url","canceled","2024-12-22 06:14:22","2024-12-22 06:14:22","10","[\"https:\\/\\/wantedrp.ir\\/f-rules\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("814","rocket_preload_job_preload_url","canceled","2024-12-22 06:15:23","2024-12-22 06:15:23","10","[\"https:\\/\\/wantedrp.ir\\/join-us\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("815","rocket_preload_job_preload_url","canceled","2024-12-22 06:15:23","2024-12-22 06:15:23","10","[\"https:\\/\\/wantedrp.ir\\/install\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("816","rocket_preload_job_preload_url","canceled","2024-12-22 06:15:23","2024-12-22 06:15:23","10","[\"https:\\/\\/wantedrp.ir\\/invite-lspd\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("817","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/wantedrp-fishing\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("818","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/category\\/%D0%BA%D0%BE%D0%BC%D0%B5%D1%82%D0%B0-%D0%BA%D0%B0%D0%B7%D0%B8%D0%BD%D0%BE\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("819","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/category\\/najbolja-zemlja-za-mladenku-za-narude%D1%95bu-poe%D1%9Ete-139\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("820","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/author\\/signorcrazy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("821","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/product\\/gang-rs\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("822","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/shop\\/page\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("823","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/product-tag\\/%D8%B1%D8%B3%D8%AA%D9%88%D8%B1%D8%A7%D9%86\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("824","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\\/product-tag\\/%DA%AF%D9%86%DA%AF\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("825","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"https:\\/\\/wantedrp.ir\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("826","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"http:\\/\\/localhost\\/blog\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("827","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"http:\\/\\/localhost\\/author\\/signorcrazy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("828","rocket_preload_job_preload_url","canceled","2024-12-22 06:16:53","2024-12-22 06:16:53","10","[\"http:\\/\\/localhost\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:05","2024-12-22 09:47:05","0",NULL),
("829","rocket_preload_job_load_initial_sitemap","complete","2024-12-22 06:17:11","2024-12-22 06:17:11","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:17:14","2024-12-22 09:47:14","0",NULL),
("830","rocket_preload_job_preload_url","complete","2024-12-22 06:17:12","2024-12-22 06:17:12","10","[\"http:\\/\\/localhost\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:17:16","2024-12-22 09:47:16","0",NULL),
("831","rocket_job_warmup","complete","2024-12-22 06:17:17","2024-12-22 06:17:17","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:17:28","2024-12-22 09:47:28","0",NULL),
("833","rocket_preload_job_preload_url","canceled","2024-12-22 06:17:20","2024-12-22 06:17:20","10","[\"http:\\/\\/localhost\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:23","2024-12-22 09:47:23","0",NULL),
("834","rocket_preload_job_preload_url","canceled","2024-12-22 06:17:20","2024-12-22 06:17:20","10","[\"http:\\/\\/localhost\\/install\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:23","2024-12-22 09:47:23","0",NULL),
("835","rocket_preload_job_preload_url","canceled","2024-12-22 06:17:20","2024-12-22 06:17:20","10","[\"http:\\/\\/localhost\\/contact\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:23","2024-12-22 09:47:23","0",NULL),
("836","rocket_preload_job_preload_url","canceled","2024-12-22 06:17:20","2024-12-22 06:17:20","10","[\"http:\\/\\/localhost\\/blog\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:23","2024-12-22 09:47:23","0",NULL),
("837","rocket_preload_job_preload_url","canceled","2024-12-22 06:17:20","2024-12-22 06:17:20","10","[\"http:\\/\\/localhost\\/shop\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:17:23","2024-12-22 09:47:23","0",NULL),
("838","rocket_preload_job_load_initial_sitemap","complete","2024-12-22 06:17:25","2024-12-22 06:17:25","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:17:29","2024-12-22 09:47:29","0",NULL),
("839","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?page_id=715\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:17:35","2024-12-22 09:47:35","0",NULL),
("840","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=other\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:17:43","2024-12-22 09:47:43","0",NULL),
("841","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=items\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:17:48","2024-12-22 09:47:48","0",NULL),
("842","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=skins\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:18:06","2024-12-22 09:48:06","0",NULL),
("843","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=game-money\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:18:24","2024-12-22 09:48:24","0",NULL),
("844","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=money\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:19:09","2024-12-22 09:49:09","0",NULL),
("845","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=diamond\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:19:13","2024-12-22 09:49:13","0",NULL),
("846","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=crime\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:19:18","2024-12-22 09:49:18","0",NULL),
("847","rocket_job_warmup_url","complete","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=gang\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:19:24","2024-12-22 09:49:24","0",NULL),
("848","rocket_job_warmup_url","failed","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\\/?product_cat=cartel\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:20:06","2024-12-22 09:50:06","0",NULL),
("849","rocket_preload_job_preload_url","canceled","2024-12-22 06:17:28","2024-12-22 06:17:28","10","[\"http:\\/\\/localhost\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","0","2024-12-22 06:18:17","2024-12-22 09:48:17","0",NULL),
("850","rocket_job_warmup","failed","2024-12-22 06:17:33","2024-12-22 06:17:33","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:20:06","2024-12-22 09:50:06","0",NULL),
("857","rocket_preload_job_load_initial_sitemap","failed","2024-12-22 06:18:45","2024-12-22 06:18:45","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","10","1","2024-12-22 06:20:06","2024-12-22 09:50:06","0",NULL),
("858","rocket_job_warmup","failed","2024-12-22 06:18:51","2024-12-22 06:18:51","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","11","1","2024-12-22 06:20:06","2024-12-22 09:50:06","0",NULL),
("859","rocket_preload_job_check_finished","failed","2024-12-22 06:19:51","2024-12-22 09:49:51","10","[1734848331]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734848391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734848391;}","10","1","2024-12-22 06:20:06","2024-12-22 09:50:06","0",NULL),
("860","action_scheduler/migration_hook","complete","2024-12-22 06:20:51","2024-12-22 09:50:51","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734848451;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734848451;}","1","1","2024-12-22 06:21:09","2024-12-22 09:51:09","0",NULL),
("861","action_scheduler/migration_hook","complete","2024-12-22 06:26:05","2024-12-22 09:56:05","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734848765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734848765;}","1","1","2024-12-22 06:26:12","2024-12-22 09:56:12","0",NULL),
("862","action_scheduler/migration_hook","complete","2024-12-22 06:37:15","2024-12-22 10:07:15","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734849435;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734849435;}","1","1","2024-12-22 06:37:52","2024-12-22 10:07:52","0",NULL),
("863","action_scheduler/migration_hook","complete","2024-12-22 06:59:08","2024-12-22 10:29:08","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734850748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734850748;}","1","1","2024-12-22 07:00:00","2024-12-22 10:30:00","0",NULL),
("864","action_scheduler/migration_hook","failed","2024-12-22 07:01:01","2024-12-22 10:31:01","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734850861;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734850861;}","1","1","2024-12-22 07:01:40","2024-12-22 10:31:40","0",NULL),
("865","woocommerce_run_product_attribute_lookup_update_callback","complete","2024-12-22 08:44:52","2024-12-22 12:14:52","10","[1739,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734857092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734857092;}","4","1","2024-12-22 08:45:04","2024-12-22 12:15:04","0",NULL),
("866","woocommerce_run_product_attribute_lookup_update_callback","complete","2024-12-22 08:44:52","2024-12-22 12:14:52","10","[1718,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734857092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734857092;}","4","1","2024-12-22 08:45:04","2024-12-22 12:15:04","0",NULL),
("867","woocommerce_run_product_attribute_lookup_update_callback","complete","2024-12-22 08:44:52","2024-12-22 12:14:52","10","[1661,3]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734857092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734857092;}","4","1","2024-12-22 08:45:04","2024-12-22 12:15:04","0",NULL),
("868","action_scheduler/migration_hook","complete","2024-12-22 08:46:23","2024-12-22 12:16:23","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734857183;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734857183;}","1","1","2024-12-22 08:46:45","2024-12-22 12:16:45","0",NULL),
("869","woocommerce_cleanup_draft_orders","pending","2024-12-23 09:29:05","2024-12-23 12:59:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734946145;s:18:\"\0*\0first_timestamp\";i:1718978285;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734946145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("870","woocommerce_cleanup_draft_orders","pending","2024-12-23 09:29:05","2024-12-23 12:59:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734946145;s:18:\"\0*\0first_timestamp\";i:1720435961;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734946145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("871","action_scheduler/migration_hook","complete","2024-12-22 10:10:29","2024-12-22 13:40:29","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1734862229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1734862229;}","1","1","2024-12-22 10:10:38","2024-12-22 13:40:38","0",NULL);

INSERT IGNORE INTO `moyhd_actionscheduler_claims` VALUES 
("23567","2024-12-20 21:36:52"),
("23573","2024-12-20 21:47:46"),
("23580","2024-12-20 21:59:50"),
("23582","2024-12-20 22:05:50"),
("23622","2024-12-21 07:14:06"),
("23624","2024-12-21 07:21:24"),
("23645","2024-12-21 07:39:44"),
("23651","2024-12-21 07:50:15"),
("23677","2024-12-21 11:28:23");

INSERT IGNORE INTO `moyhd_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2",""),
("3","wc_update_product_default_cat"),
("4","woocommerce-db-updates"),
("5","imagify-wp-optimize-media"),
("6","imagify-custom-folders-optimize-media"),
("7","wc-admin-data"),
("8","woocommerce-remote-inbox-engine"),
("9","woocommerce-remote-inbox-engine"),
("10","rocket-preload"),
("11","rocket-performance-hints-warmup");

INSERT IGNORE INTO `moyhd_actionscheduler_logs` VALUES 
("6","14","ایجاد فعالیت","2024-06-21 13:58:51","2024-06-21 14:58:51"),
("7","14","عملیات توسط Async Request شروع شد","2024-06-21 13:59:05","2024-06-21 14:59:05"),
("8","14","اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.","2024-06-21 13:59:05","2024-06-21 14:59:05"),
("14","16","ایجاد فعالیت","2024-06-21 14:06:08","2024-06-21 15:06:08"),
("15","16","عملیات توسط Async Request شروع شد","2024-06-21 14:07:17","2024-06-21 15:07:17"),
("16","16","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-06-21 14:07:17","2024-06-21 15:07:17"),
("20","18","ایجاد فعالیت","2024-06-21 14:19:14","2024-06-21 15:19:14"),
("21","18","عملیات توسط Async Request شروع شد","2024-06-21 14:20:17","2024-06-21 15:20:17"),
("22","18","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-06-21 14:20:17","2024-06-21 15:20:17"),
("110","48","ایجاد فعالیت","2024-06-22 09:17:49","2024-06-22 10:17:49"),
("111","48","عملیات توسط WP Cron شروع شد","2024-06-22 09:19:02","2024-06-22 10:19:02"),
("112","48","اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-06-22 09:19:02","2024-06-22 10:19:02"),
("275","103","ایجاد فعالیت","2024-06-22 10:11:25","2024-06-22 11:11:25"),
("276","103","عملیات توسط Async Request شروع شد","2024-06-22 10:13:27","2024-06-22 11:13:27"),
("277","103","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-06-22 10:13:27","2024-06-22 11:13:27"),
("317","117","ایجاد فعالیت","2024-06-28 09:57:09","2024-06-28 10:57:09"),
("318","117","عملیات توسط Async Request شروع شد","2024-06-28 09:58:09","2024-06-28 10:58:09"),
("319","117","اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-06-28 09:58:09","2024-06-28 10:58:09"),
("867","301","عملیات ایجاد شد","2024-09-15 08:12:31","2024-09-15 12:42:31"),
("868","301","عملیات با WP Cron شروع شد","2024-09-15 08:13:53","2024-09-15 12:43:53"),
("869","301","عملکرد از طریقWP Cron انجام نشد:Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-09-15 08:13:53","2024-09-15 12:43:53"),
("1244","426","عملیات ایجاد شد","2024-11-21 19:23:05","2024-11-21 22:53:05"),
("1247","427","عملیات ایجاد شد","2024-11-21 19:23:05","2024-11-21 22:53:05"),
("1248","426","عملیات با WP Cron شروع شد","2024-11-22 20:50:47","2024-11-23 00:20:47"),
("1249","426","عملیات با WP Cron تکمیل شد","2024-11-22 20:50:47","2024-11-23 00:20:47"),
("1250","428","عملیات ایجاد شد","2024-11-22 20:50:47","2024-11-23 00:20:47"),
("1251","427","عملیات با WP Cron شروع شد","2024-11-22 20:50:47","2024-11-23 00:20:47"),
("1252","427","عملیات با WP Cron تکمیل شد","2024-11-22 20:50:47","2024-11-23 00:20:47"),
("1253","429","عملیات ایجاد شد","2024-11-22 20:50:47","2024-11-23 00:20:47"),
("1254","428","عملیات با WP Cron شروع شد","2024-11-23 20:53:54","2024-11-24 00:23:54"),
("1255","428","عملیات با WP Cron تکمیل شد","2024-11-23 20:53:54","2024-11-24 00:23:54"),
("1256","430","عملیات ایجاد شد","2024-11-23 20:53:54","2024-11-24 00:23:54"),
("1257","429","عملیات با WP Cron شروع شد","2024-11-23 20:53:54","2024-11-24 00:23:54"),
("1258","429","عملیات با WP Cron تکمیل شد","2024-11-23 20:53:54","2024-11-24 00:23:54"),
("1259","431","عملیات ایجاد شد","2024-11-23 20:53:54","2024-11-24 00:23:54"),
("1260","430","عملیات با WP Cron شروع شد","2024-11-24 20:53:54","2024-11-25 00:23:54"),
("1261","430","عملیات با WP Cron تکمیل شد","2024-11-24 20:53:54","2024-11-25 00:23:54"),
("1262","432","عملیات ایجاد شد","2024-11-24 20:53:54","2024-11-25 00:23:54"),
("1263","431","عملیات با WP Cron شروع شد","2024-11-24 20:53:54","2024-11-25 00:23:54"),
("1264","431","عملیات با WP Cron تکمیل شد","2024-11-24 20:53:54","2024-11-25 00:23:54"),
("1265","433","عملیات ایجاد شد","2024-11-24 20:53:54","2024-11-25 00:23:54"),
("1266","432","عملیات با WP Cron شروع شد","2024-11-25 22:42:05","2024-11-26 02:12:05"),
("1267","432","عملیات با WP Cron تکمیل شد","2024-11-25 22:42:05","2024-11-26 02:12:05"),
("1268","434","عملیات ایجاد شد","2024-11-25 22:42:05","2024-11-26 02:12:05"),
("1269","433","عملیات با WP Cron شروع شد","2024-11-25 22:42:05","2024-11-26 02:12:05"),
("1270","433","عملیات با WP Cron تکمیل شد","2024-11-25 22:42:05","2024-11-26 02:12:05"),
("1271","435","عملیات ایجاد شد","2024-11-25 22:42:05","2024-11-26 02:12:05"),
("1272","434","عملیات با WP Cron شروع شد","2024-11-26 22:59:35","2024-11-27 02:29:35"),
("1273","434","عملیات با WP Cron تکمیل شد","2024-11-26 22:59:35","2024-11-27 02:29:35"),
("1274","436","عملیات ایجاد شد","2024-11-26 22:59:35","2024-11-27 02:29:35"),
("1275","435","عملیات با WP Cron شروع شد","2024-11-26 22:59:35","2024-11-27 02:29:35"),
("1276","435","عملیات با WP Cron تکمیل شد","2024-11-26 22:59:35","2024-11-27 02:29:35"),
("1277","437","عملیات ایجاد شد","2024-11-26 22:59:35","2024-11-27 02:29:35"),
("1278","436","عملیات با WP Cron شروع شد","2024-11-27 23:18:12","2024-11-28 02:48:12"),
("1279","436","عملیات با WP Cron تکمیل شد","2024-11-27 23:18:12","2024-11-28 02:48:12"),
("1280","438","عملیات ایجاد شد","2024-11-27 23:18:12","2024-11-28 02:48:12"),
("1281","437","عملیات با WP Cron شروع شد","2024-11-27 23:18:12","2024-11-28 02:48:12"),
("1282","437","عملیات با WP Cron تکمیل شد","2024-11-27 23:18:12","2024-11-28 02:48:12"),
("1283","439","عملیات ایجاد شد","2024-11-27 23:18:12","2024-11-28 02:48:12"),
("1284","438","عملیات با WP Cron شروع شد","2024-11-28 23:28:39","2024-11-29 02:58:39"),
("1285","438","عملیات با WP Cron تکمیل شد","2024-11-28 23:28:39","2024-11-29 02:58:39"),
("1286","440","عملیات ایجاد شد","2024-11-28 23:28:39","2024-11-29 02:58:39"),
("1287","439","عملیات با WP Cron شروع شد","2024-11-28 23:28:39","2024-11-29 02:58:39"),
("1288","439","عملیات با WP Cron تکمیل شد","2024-11-28 23:28:39","2024-11-29 02:58:39"),
("1289","441","عملیات ایجاد شد","2024-11-28 23:28:39","2024-11-29 02:58:39"),
("1290","440","عملیات با WP Cron شروع شد","2024-11-29 23:37:59","2024-11-30 03:07:59"),
("1291","440","عملیات با WP Cron تکمیل شد","2024-11-29 23:37:59","2024-11-30 03:07:59"),
("1292","442","عملیات ایجاد شد","2024-11-29 23:37:59","2024-11-30 03:07:59"),
("1293","441","عملیات با WP Cron شروع شد","2024-11-29 23:37:59","2024-11-30 03:07:59"),
("1294","441","عملیات با WP Cron تکمیل شد","2024-11-29 23:37:59","2024-11-30 03:07:59"),
("1295","443","عملیات ایجاد شد","2024-11-29 23:37:59","2024-11-30 03:07:59"),
("1296","442","عملیات با WP Cron شروع شد","2024-11-30 23:57:03","2024-12-01 03:27:03"),
("1297","442","عملیات با WP Cron تکمیل شد","2024-11-30 23:57:03","2024-12-01 03:27:03"),
("1298","444","عملیات ایجاد شد","2024-11-30 23:57:03","2024-12-01 03:27:03"),
("1299","443","عملیات با WP Cron شروع شد","2024-11-30 23:57:03","2024-12-01 03:27:03"),
("1300","443","عملیات با WP Cron تکمیل شد","2024-11-30 23:57:03","2024-12-01 03:27:03"),
("1301","445","عملیات ایجاد شد","2024-11-30 23:57:03","2024-12-01 03:27:03"),
("1302","444","عملیات با WP Cron شروع شد","2024-12-02 00:10:20","2024-12-02 03:40:20"),
("1303","444","عملیات با WP Cron تکمیل شد","2024-12-02 00:10:20","2024-12-02 03:40:20"),
("1304","446","عملیات ایجاد شد","2024-12-02 00:10:20","2024-12-02 03:40:20"),
("1305","445","عملیات با WP Cron شروع شد","2024-12-02 00:10:20","2024-12-02 03:40:20"),
("1306","445","عملیات با WP Cron تکمیل شد","2024-12-02 00:10:20","2024-12-02 03:40:20"),
("1307","447","عملیات ایجاد شد","2024-12-02 00:10:20","2024-12-02 03:40:20"),
("1308","446","عملیات با WP Cron شروع شد","2024-12-03 00:28:32","2024-12-03 03:58:32"),
("1309","446","عملیات با WP Cron تکمیل شد","2024-12-03 00:28:32","2024-12-03 03:58:32"),
("1310","448","عملیات ایجاد شد","2024-12-03 00:28:32","2024-12-03 03:58:32"),
("1311","447","عملیات با WP Cron شروع شد","2024-12-03 00:28:32","2024-12-03 03:58:32"),
("1312","447","عملیات با WP Cron تکمیل شد","2024-12-03 00:28:32","2024-12-03 03:58:32"),
("1313","449","عملیات ایجاد شد","2024-12-03 00:28:32","2024-12-03 03:58:32"),
("1314","448","عملیات با WP Cron شروع شد","2024-12-04 00:30:21","2024-12-04 04:00:21"),
("1315","448","عملیات با WP Cron تکمیل شد","2024-12-04 00:30:21","2024-12-04 04:00:21"),
("1316","450","عملیات ایجاد شد","2024-12-04 00:30:21","2024-12-04 04:00:21"),
("1317","449","عملیات با WP Cron شروع شد","2024-12-04 00:30:21","2024-12-04 04:00:21"),
("1318","449","عملیات با WP Cron تکمیل شد","2024-12-04 00:30:21","2024-12-04 04:00:21"),
("1319","451","عملیات ایجاد شد","2024-12-04 00:30:21","2024-12-04 04:00:21"),
("1320","452","عملیات ایجاد شد","2024-12-04 02:17:01","2024-12-04 05:47:01"),
("1321","452","عملیات با WP Cron شروع شد","2024-12-04 02:17:30","2024-12-04 05:47:30"),
("1322","452","عملیات با WP Cron تکمیل شد","2024-12-04 02:17:30","2024-12-04 05:47:30"),
("1323","450","عملیات با WP Cron شروع شد","2024-12-05 01:41:27","2024-12-05 05:11:27"),
("1324","450","عملیات با WP Cron تکمیل شد","2024-12-05 01:41:28","2024-12-05 05:11:28"),
("1325","453","عملیات ایجاد شد","2024-12-05 01:41:28","2024-12-05 05:11:28"),
("1326","451","عملیات با WP Cron شروع شد","2024-12-05 01:41:28","2024-12-05 05:11:28"),
("1327","451","عملیات با WP Cron تکمیل شد","2024-12-05 01:41:28","2024-12-05 05:11:28"),
("1328","454","عملیات ایجاد شد","2024-12-05 01:41:28","2024-12-05 05:11:28"),
("1329","453","عملیات با WP Cron شروع شد","2024-12-06 01:55:49","2024-12-06 05:25:49"),
("1330","453","عملیات با WP Cron تکمیل شد","2024-12-06 01:55:49","2024-12-06 05:25:49"),
("1331","455","عملیات ایجاد شد","2024-12-06 01:55:49","2024-12-06 05:25:49"),
("1332","454","عملیات با WP Cron شروع شد","2024-12-06 01:55:49","2024-12-06 05:25:49"),
("1333","454","عملیات با WP Cron تکمیل شد","2024-12-06 01:55:49","2024-12-06 05:25:49"),
("1334","456","عملیات ایجاد شد","2024-12-06 01:55:49","2024-12-06 05:25:49"),
("1335","455","عملیات با WP Cron شروع شد","2024-12-07 02:16:45","2024-12-07 05:46:45"),
("1336","455","عملیات با WP Cron تکمیل شد","2024-12-07 02:16:45","2024-12-07 05:46:45"),
("1337","457","عملیات ایجاد شد","2024-12-07 02:16:45","2024-12-07 05:46:45"),
("1338","456","عملیات با WP Cron شروع شد","2024-12-07 02:16:45","2024-12-07 05:46:45"),
("1339","456","عملیات با WP Cron تکمیل شد","2024-12-07 02:16:45","2024-12-07 05:46:45"),
("1340","458","عملیات ایجاد شد","2024-12-07 02:16:45","2024-12-07 05:46:45"),
("1341","457","عملیات با WP Cron شروع شد","2024-12-08 02:18:26","2024-12-08 05:48:26"),
("1342","457","عملیات با WP Cron تکمیل شد","2024-12-08 02:18:26","2024-12-08 05:48:26"),
("1343","459","عملیات ایجاد شد","2024-12-08 02:18:26","2024-12-08 05:48:26"),
("1344","458","عملیات با WP Cron شروع شد","2024-12-08 02:18:26","2024-12-08 05:48:26"),
("1345","458","عملیات با WP Cron تکمیل شد","2024-12-08 02:18:26","2024-12-08 05:48:26"),
("1346","460","عملیات ایجاد شد","2024-12-08 02:18:26","2024-12-08 05:48:26"),
("1347","459","عملیات با WP Cron شروع شد","2024-12-09 02:21:46","2024-12-09 05:51:46"),
("1348","459","عملیات با WP Cron تکمیل شد","2024-12-09 02:21:46","2024-12-09 05:51:46"),
("1349","461","عملیات ایجاد شد","2024-12-09 02:21:46","2024-12-09 05:51:46"),
("1350","460","عملیات با WP Cron شروع شد","2024-12-09 02:21:46","2024-12-09 05:51:46"),
("1351","460","عملیات با WP Cron تکمیل شد","2024-12-09 02:21:46","2024-12-09 05:51:46"),
("1352","462","عملیات ایجاد شد","2024-12-09 02:21:46","2024-12-09 05:51:46"),
("1353","461","عملیات با WP Cron شروع شد","2024-12-10 02:36:59","2024-12-10 06:06:59"),
("1354","461","عملیات با WP Cron تکمیل شد","2024-12-10 02:36:59","2024-12-10 06:06:59"),
("1355","463","عملیات ایجاد شد","2024-12-10 02:36:59","2024-12-10 06:06:59"),
("1356","462","عملیات با WP Cron شروع شد","2024-12-10 02:36:59","2024-12-10 06:06:59"),
("1357","462","عملیات با WP Cron تکمیل شد","2024-12-10 02:36:59","2024-12-10 06:06:59"),
("1358","464","عملیات ایجاد شد","2024-12-10 02:36:59","2024-12-10 06:06:59"),
("1359","463","عملیات با WP Cron شروع شد","2024-12-11 02:47:33","2024-12-11 06:17:33"),
("1360","463","عملیات با WP Cron تکمیل شد","2024-12-11 02:47:34","2024-12-11 06:17:34"),
("1361","465","عملیات ایجاد شد","2024-12-11 02:47:34","2024-12-11 06:17:34"),
("1362","464","عملیات با WP Cron شروع شد","2024-12-11 02:47:34","2024-12-11 06:17:34"),
("1363","464","عملیات با WP Cron تکمیل شد","2024-12-11 02:47:34","2024-12-11 06:17:34"),
("1364","466","عملیات ایجاد شد","2024-12-11 02:47:34","2024-12-11 06:17:34"),
("1365","465","عملیات با WP Cron شروع شد","2024-12-12 03:11:29","2024-12-12 06:41:29"),
("1366","465","عملیات با WP Cron تکمیل شد","2024-12-12 03:11:29","2024-12-12 06:41:29"),
("1367","467","عملیات ایجاد شد","2024-12-12 03:11:29","2024-12-12 06:41:29"),
("1368","466","عملیات با WP Cron شروع شد","2024-12-12 03:11:29","2024-12-12 06:41:29"),
("1369","466","عملیات با WP Cron تکمیل شد","2024-12-12 03:11:29","2024-12-12 06:41:29"),
("1370","468","عملیات ایجاد شد","2024-12-12 03:11:29","2024-12-12 06:41:29"),
("1371","467","عملیات با WP Cron شروع شد","2024-12-13 03:11:42","2024-12-13 06:41:42"),
("1372","467","عملیات با WP Cron تکمیل شد","2024-12-13 03:11:42","2024-12-13 06:41:42"),
("1373","469","عملیات ایجاد شد","2024-12-13 03:11:42","2024-12-13 06:41:42"),
("1374","468","عملیات با WP Cron شروع شد","2024-12-13 03:11:42","2024-12-13 06:41:42"),
("1375","468","عملیات با WP Cron تکمیل شد","2024-12-13 03:11:42","2024-12-13 06:41:42"),
("1376","470","عملیات ایجاد شد","2024-12-13 03:11:42","2024-12-13 06:41:42"),
("1377","469","عملیات با WP Cron شروع شد","2024-12-14 07:41:15","2024-12-14 11:11:15"),
("1378","469","عملیات با WP Cron تکمیل شد","2024-12-14 07:41:15","2024-12-14 11:11:15"),
("1379","471","عملیات ایجاد شد","2024-12-14 07:41:15","2024-12-14 11:11:15"),
("1380","470","عملیات با WP Cron شروع شد","2024-12-14 07:41:15","2024-12-14 11:11:15"),
("1381","470","عملیات با WP Cron تکمیل شد","2024-12-14 07:41:15","2024-12-14 11:11:15"),
("1382","472","عملیات ایجاد شد","2024-12-14 07:41:15","2024-12-14 11:11:15"),
("1383","471","عملیات با WP Cron شروع شد","2024-12-15 07:41:26","2024-12-15 11:11:26"),
("1384","471","عملیات با WP Cron تکمیل شد","2024-12-15 07:41:26","2024-12-15 11:11:26"),
("1385","473","عملیات ایجاد شد","2024-12-15 07:41:26","2024-12-15 11:11:26"),
("1386","472","عملیات با WP Cron شروع شد","2024-12-15 07:41:26","2024-12-15 11:11:26"),
("1387","472","عملیات با WP Cron تکمیل شد","2024-12-15 07:41:26","2024-12-15 11:11:26"),
("1388","474","عملیات ایجاد شد","2024-12-15 07:41:26","2024-12-15 11:11:26"),
("1389","473","عملیات با WP Cron شروع شد","2024-12-16 07:44:18","2024-12-16 11:14:18"),
("1390","473","عملیات با WP Cron تکمیل شد","2024-12-16 07:44:18","2024-12-16 11:14:18"),
("1391","475","عملیات ایجاد شد","2024-12-16 07:44:18","2024-12-16 11:14:18"),
("1392","474","عملیات با WP Cron شروع شد","2024-12-16 07:44:18","2024-12-16 11:14:18"),
("1393","474","عملیات با WP Cron تکمیل شد","2024-12-16 07:44:18","2024-12-16 11:14:18"),
("1394","476","عملیات ایجاد شد","2024-12-16 07:44:18","2024-12-16 11:14:18"),
("1395","475","عملیات با WP Cron شروع شد","2024-12-17 08:19:10","2024-12-17 11:49:10"),
("1396","475","عملیات با WP Cron تکمیل شد","2024-12-17 08:19:10","2024-12-17 11:49:10"),
("1397","477","عملیات ایجاد شد","2024-12-17 08:19:10","2024-12-17 11:49:10"),
("1398","476","عملیات با WP Cron شروع شد","2024-12-17 08:19:10","2024-12-17 11:49:10"),
("1399","476","عملیات با WP Cron تکمیل شد","2024-12-17 08:19:10","2024-12-17 11:49:10"),
("1400","478","عملیات ایجاد شد","2024-12-17 08:19:10","2024-12-17 11:49:10"),
("1401","479","عملیات ایجاد شد","2024-12-18 01:52:01","2024-12-18 05:22:01"),
("1402","479","عملیات با Async Request شروع شد","2024-12-18 01:52:24","2024-12-18 05:22:24"),
("1403","479","عملیات با Async Request تکمیل شد","2024-12-18 01:52:24","2024-12-18 05:22:24"),
("1404","477","عملیات با WP Cron شروع شد","2024-12-18 08:26:29","2024-12-18 11:56:29"),
("1405","477","عملیات با WP Cron تکمیل شد","2024-12-18 08:26:29","2024-12-18 11:56:29"),
("1406","480","عملیات ایجاد شد","2024-12-18 08:26:30","2024-12-18 11:56:30"),
("1407","478","عملیات با WP Cron شروع شد","2024-12-18 08:26:30","2024-12-18 11:56:30"),
("1408","478","عملیات با WP Cron تکمیل شد","2024-12-18 08:26:30","2024-12-18 11:56:30"),
("1409","481","عملیات ایجاد شد","2024-12-18 08:26:30","2024-12-18 11:56:30"),
("1410","482","عملیات ایجاد شد","2024-12-19 05:20:58","2024-12-19 08:50:58"),
("1411","483","عملیات ایجاد شد","2024-12-19 05:20:58","2024-12-19 08:50:58"),
("1412","484","عملیات ایجاد شد","2024-12-19 05:20:58","2024-12-19 08:50:58"),
("1413","485","عملیات ایجاد شد","2024-12-19 05:20:58","2024-12-19 08:50:58"),
("1414","482","عملیات با WP Cron شروع شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1415","482","عملیات با WP Cron تکمیل شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1416","483","عملیات با WP Cron شروع شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1417","483","عملیات با WP Cron تکمیل شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1418","484","عملیات با WP Cron شروع شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1419","484","عملیات با WP Cron تکمیل شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1420","485","عملیات با WP Cron شروع شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1421","485","عملیات با WP Cron تکمیل شد","2024-12-19 05:21:17","2024-12-19 08:51:17"),
("1422","480","عملیات با WP Cron شروع شد","2024-12-19 08:47:39","2024-12-19 12:17:39"),
("1423","480","عملیات با WP Cron تکمیل شد","2024-12-19 08:47:39","2024-12-19 12:17:39"),
("1424","486","عملیات ایجاد شد","2024-12-19 08:47:39","2024-12-19 12:17:39"),
("1425","481","عملیات با WP Cron شروع شد","2024-12-19 08:47:39","2024-12-19 12:17:39"),
("1426","481","عملیات با WP Cron تکمیل شد","2024-12-19 08:47:39","2024-12-19 12:17:39"),
("1427","487","عملیات ایجاد شد","2024-12-19 08:47:39","2024-12-19 12:17:39"),
("1428","486","عملیات با WP Cron شروع شد","2024-12-20 09:15:15","2024-12-20 12:45:15"),
("1429","486","عملیات با WP Cron تکمیل شد","2024-12-20 09:15:15","2024-12-20 12:45:15"),
("1430","488","عملیات ایجاد شد","2024-12-20 09:15:16","2024-12-20 12:45:16"),
("1431","487","عملیات با WP Cron شروع شد","2024-12-20 09:15:16","2024-12-20 12:45:16"),
("1432","487","عملیات با WP Cron تکمیل شد","2024-12-20 09:15:16","2024-12-20 12:45:16"),
("1433","489","عملیات ایجاد شد","2024-12-20 09:15:16","2024-12-20 12:45:16"),
("1435","491","عملیات ایجاد شد","2024-12-20 21:26:59","2024-12-21 00:56:59"),
("1439","491","عملیات با Async Request شروع شد","2024-12-20 21:28:07","2024-12-21 00:58:07"),
("1440","493","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1441","494","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1442","495","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1443","496","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1444","497","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1445","498","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1446","499","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1447","500","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1448","501","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1449","502","عملیات ایجاد شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1450","491","عملیات با Async Request تکمیل شد","2024-12-20 21:28:17","2024-12-21 00:58:17"),
("1453","493","عملیات با Async Request شروع شد","2024-12-20 21:28:27","2024-12-21 00:58:27"),
("1454","493","عملیات با Async Request تکمیل شد","2024-12-20 21:28:28","2024-12-21 00:58:28"),
("1455","494","عملیات با Async Request شروع شد","2024-12-20 21:28:28","2024-12-21 00:58:28"),
("1456","494","عملیات با Async Request تکمیل شد","2024-12-20 21:28:28","2024-12-21 00:58:28"),
("1457","495","عملیات با Async Request شروع شد","2024-12-20 21:28:28","2024-12-21 00:58:28"),
("1458","495","عملیات با Async Request تکمیل شد","2024-12-20 21:28:28","2024-12-21 00:58:28"),
("1459","496","عملیات با Async Request شروع شد","2024-12-20 21:28:28","2024-12-21 00:58:28"),
("1460","496","عملیات با Async Request تکمیل شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1461","497","عملیات با Async Request شروع شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1462","497","عملیات با Async Request تکمیل شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1463","498","عملیات با Async Request شروع شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1464","498","عملیات با Async Request تکمیل شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1465","499","عملیات با Async Request شروع شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1466","499","عملیات با Async Request تکمیل شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1467","500","عملیات با Async Request شروع شد","2024-12-20 21:28:29","2024-12-21 00:58:29"),
("1468","500","عملیات با Async Request تکمیل شد","2024-12-20 21:28:30","2024-12-21 00:58:30"),
("1469","501","عملیات با Async Request شروع شد","2024-12-20 21:28:30","2024-12-21 00:58:30"),
("1470","501","عملیات با Async Request تکمیل شد","2024-12-20 21:28:30","2024-12-21 00:58:30"),
("1471","502","عملیات با Async Request شروع شد","2024-12-20 21:28:30","2024-12-21 00:58:30"),
("1472","502","عملیات با Async Request تکمیل شد","2024-12-20 21:28:30","2024-12-21 00:58:30"),
("1520","533","عملیات ایجاد شد","2024-12-20 21:38:20","2024-12-21 01:08:20"),
("1605","533","عملیات بازنشانی شد","2024-12-20 21:53:08","2024-12-21 01:23:08"),
("1632","533","عملیات با WP Cron شروع شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1633","573","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1634","574","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1635","575","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1636","576","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1637","577","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1638","578","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1639","579","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1640","580","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1641","581","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1642","582","عملیات ایجاد شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1643","533","عملیات با WP Cron تکمیل شد","2024-12-20 21:54:10","2024-12-21 01:24:10"),
("1726","573","عملیات با WP Cron شروع شد","2024-12-20 21:57:21","2024-12-21 01:27:21"),
("1727","573","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:21","2024-12-21 01:27:21"),
("1728","574","عملیات با WP Cron شروع شد","2024-12-20 21:57:21","2024-12-21 01:27:21"),
("1729","574","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:22","2024-12-21 01:27:22"),
("1730","575","عملیات با WP Cron شروع شد","2024-12-20 21:57:22","2024-12-21 01:27:22"),
("1731","575","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:23","2024-12-21 01:27:23"),
("1732","576","عملیات با WP Cron شروع شد","2024-12-20 21:57:23","2024-12-21 01:27:23"),
("1733","576","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:23","2024-12-21 01:27:23"),
("1734","577","عملیات با WP Cron شروع شد","2024-12-20 21:57:23","2024-12-21 01:27:23"),
("1735","577","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:24","2024-12-21 01:27:24"),
("1736","578","عملیات با WP Cron شروع شد","2024-12-20 21:57:24","2024-12-21 01:27:24"),
("1737","578","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:25","2024-12-21 01:27:25"),
("1738","579","عملیات با WP Cron شروع شد","2024-12-20 21:57:25","2024-12-21 01:27:25"),
("1739","579","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:25","2024-12-21 01:27:25"),
("1740","580","عملیات با WP Cron شروع شد","2024-12-20 21:57:25","2024-12-21 01:27:25"),
("1741","580","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:26","2024-12-21 01:27:26"),
("1742","581","عملیات با WP Cron شروع شد","2024-12-20 21:57:26","2024-12-21 01:27:26"),
("1743","581","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:27","2024-12-21 01:27:27"),
("1744","582","عملیات با WP Cron شروع شد","2024-12-20 21:57:27","2024-12-21 01:27:27"),
("1745","582","عملیات با WP Cron تکمیل شد","2024-12-20 21:57:27","2024-12-21 01:27:27"),
("1934","654","عملیات ایجاد شد","2024-12-21 07:26:31","2024-12-21 10:56:31"),
("1996","654","عملیات با WP Cron شروع شد","2024-12-21 07:32:25","2024-12-21 11:02:25"),
("1997","654","عملیات با WP Cron تکمیل شد","2024-12-21 07:32:25","2024-12-21 11:02:25"),
("2102","708","عملیات ایجاد شد","2024-12-21 07:38:32","2024-12-21 11:08:32"),
("2135","708","عملیات بازنشانی شد","2024-12-21 07:45:33","2024-12-21 11:15:33"),
("2184","708","عملیات با Async Request شروع شد","2024-12-21 07:50:15","2024-12-21 11:20:15"),
("2185","708","عملیات با Async Request تکمیل شد","2024-12-21 07:50:15","2024-12-21 11:20:15"),
("2240","488","عملیات با WP Cron شروع شد","2024-12-21 09:28:54","2024-12-21 12:58:54"),
("2241","488","عملیات با WP Cron تکمیل شد","2024-12-21 09:28:54","2024-12-21 12:58:54"),
("2242","728","عملیات ایجاد شد","2024-12-21 09:28:54","2024-12-21 12:58:54"),
("2243","489","عملیات با WP Cron شروع شد","2024-12-21 09:28:54","2024-12-21 12:58:54"),
("2244","489","عملیات با WP Cron تکمیل شد","2024-12-21 09:28:54","2024-12-21 12:58:54"),
("2245","729","عملیات ایجاد شد","2024-12-21 09:28:54","2024-12-21 12:58:54"),
("2246","730","عملیات ایجاد شد","2024-12-21 11:25:50","2024-12-21 14:55:50"),
("2276","758","عملیات ایجاد شد","2024-12-21 11:27:28","2024-12-21 14:57:28"),
("2277","759","عملیات ایجاد شد","2024-12-21 11:27:28","2024-12-21 14:57:28"),
("2278","760","عملیات ایجاد شد","2024-12-21 11:27:28","2024-12-21 14:57:28"),
("2279","761","عملیات ایجاد شد","2024-12-21 11:27:28","2024-12-21 14:57:28"),
("2280","762","عملیات ایجاد شد","2024-12-21 11:27:28","2024-12-21 14:57:28"),
("2281","763","عملیات ایجاد شد","2024-12-21 11:27:28","2024-12-21 14:57:28"),
("2290","730","عملیات با Async Request شروع شد","2024-12-21 11:27:59","2024-12-21 14:57:59"),
("2291","730","عملیات با Async Request تکمیل شد","2024-12-21 11:27:59","2024-12-21 14:57:59"),
("2293","764","عملیات ایجاد شد","2024-12-21 11:27:59","2024-12-21 14:57:59"),
("2296","765","عملیات ایجاد شد","2024-12-21 11:28:02","2024-12-21 14:58:02"),
("2305","766","عملیات ایجاد شد","2024-12-21 11:29:28","2024-12-21 14:59:28"),
("2306","767","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2307","768","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2308","769","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2309","770","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2310","771","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2311","772","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2312","773","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2313","774","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2314","775","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2315","776","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2316","777","عملیات ایجاد شد","2024-12-21 11:30:24","2024-12-21 15:00:24"),
("2317","778","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2318","779","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2319","780","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2320","781","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2321","782","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2322","783","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2323","784","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2324","785","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2325","786","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2326","787","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2327","788","عملیات ایجاد شد","2024-12-21 11:30:25","2024-12-21 15:00:25"),
("2344","758","عملیات بازنشانی شد","2024-12-21 11:34:26","2024-12-21 15:04:26"),
("2345","759","عملیات بازنشانی شد","2024-12-21 11:34:26","2024-12-21 15:04:26"),
("2346","760","عملیات بازنشانی شد","2024-12-21 11:34:26","2024-12-21 15:04:26"),
("2347","761","عملیات بازنشانی شد","2024-12-21 11:34:26","2024-12-21 15:04:26"),
("2349","762","عملیات بازنشانی شد","2024-12-21 11:34:26","2024-12-21 15:04:26"),
("2350","763","عملیات بازنشانی شد","2024-12-21 11:34:26","2024-12-21 15:04:26"),
("2373","789","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2374","790","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2375","791","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2376","792","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2377","793","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2378","794","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2379","795","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2380","796","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2381","797","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2382","798","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2383","799","عملیات ایجاد شد","2024-12-21 11:36:56","2024-12-21 15:06:56"),
("2394","758","عملیات با WP Cron شروع شد","2024-12-22 06:11:00","2024-12-22 09:41:00"),
("2395","758","عملیات با WP Cron تکمیل شد","2024-12-22 06:11:07","2024-12-22 09:41:07"),
("2396","759","عملیات با Async Request شروع شد","2024-12-22 06:11:37","2024-12-22 09:41:37"),
("2397","759","عملیات با Async Request تکمیل شد","2024-12-22 06:11:40","2024-12-22 09:41:40"),
("2398","760","عملیات با Async Request شروع شد","2024-12-22 06:11:52","2024-12-22 09:41:52"),
("2399","760","عملیات با Async Request تکمیل شد","2024-12-22 06:11:55","2024-12-22 09:41:55"),
("2400","761","عملیات با Async Request شروع شد","2024-12-22 06:12:07","2024-12-22 09:42:07"),
("2401","761","عملیات با Async Request تکمیل شد","2024-12-22 06:12:15","2024-12-22 09:42:15"),
("2402","762","عملیات با Async Request شروع شد","2024-12-22 06:13:10","2024-12-22 09:43:10"),
("2403","762","عملیات با Async Request تکمیل شد","2024-12-22 06:13:17","2024-12-22 09:43:17"),
("2404","763","عملیات با Async Request شروع شد","2024-12-22 06:13:28","2024-12-22 09:43:28"),
("2405","763","عملیات با Async Request تکمیل شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2406","764","عملیات با Async Request شروع شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2407","800","عملیات ایجاد شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2408","764","عملیات با Async Request تکمیل شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2409","765","عملیات با Async Request شروع شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2410","765","عملیات با Async Request تکمیل شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2411","766","عملیات با Async Request شروع شد","2024-12-22 06:13:31","2024-12-22 09:43:31"),
("2412","801","عملیات ایجاد شد","2024-12-22 06:13:32","2024-12-22 09:43:32"),
("2413","766","عملیات با Async Request تکمیل شد","2024-12-22 06:13:34","2024-12-22 09:43:34"),
("2414","767","عملیات با Async Request شروع شد","2024-12-22 06:13:34","2024-12-22 09:43:34"),
("2415","767","عملیات با Async Request تکمیل شد","2024-12-22 06:13:37","2024-12-22 09:43:37"),
("2416","768","عملیات با Async Request شروع شد","2024-12-22 06:13:37","2024-12-22 09:43:37"),
("2417","768","عملیات با Async Request تکمیل شد","2024-12-22 06:13:40","2024-12-22 09:43:40"),
("2418","769","عملیات با Async Request شروع شد","2024-12-22 06:13:40","2024-12-22 09:43:40"),
("2419","769","عملیات با Async Request تکمیل شد","2024-12-22 06:13:43","2024-12-22 09:43:43"),
("2420","770","عملیات با Async Request شروع شد","2024-12-22 06:13:43","2024-12-22 09:43:43"),
("2421","770","عملیات با Async Request تکمیل شد","2024-12-22 06:13:46","2024-12-22 09:43:46"),
("2422","771","عملیات با Async Request شروع شد","2024-12-22 06:13:54","2024-12-22 09:43:54"),
("2423","771","عملیات با Async Request تکمیل شد","2024-12-22 06:13:57","2024-12-22 09:43:57"),
("2424","772","عملیات با Async Request شروع شد","2024-12-22 06:13:57","2024-12-22 09:43:57"),
("2425","772","عملیات با Async Request تکمیل شد","2024-12-22 06:14:00","2024-12-22 09:44:00"),
("2426","773","عملیات با Async Request شروع شد","2024-12-22 06:14:00","2024-12-22 09:44:00"),
("2427","773","عملیات با Async Request تکمیل شد","2024-12-22 06:14:03","2024-12-22 09:44:03"),
("2428","774","عملیات با Async Request شروع شد","2024-12-22 06:14:03","2024-12-22 09:44:03"),
("2429","774","عملیات با Async Request تکمیل شد","2024-12-22 06:14:06","2024-12-22 09:44:06"),
("2430","775","عملیات با Async Request شروع شد","2024-12-22 06:14:06","2024-12-22 09:44:06"),
("2431","775","عملیات با Async Request تکمیل شد","2024-12-22 06:14:09","2024-12-22 09:44:09"),
("2432","776","عملیات با Async Request شروع شد","2024-12-22 06:14:09","2024-12-22 09:44:09"),
("2433","776","عملیات با Async Request تکمیل شد","2024-12-22 06:14:12","2024-12-22 09:44:12"),
("2434","777","عملیات با Async Request شروع شد","2024-12-22 06:14:21","2024-12-22 09:44:21"),
("2435","802","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2436","803","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2437","804","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2438","805","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2439","806","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2440","807","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2441","808","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2442","809","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2443","810","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2444","811","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2445","812","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2446","813","عملیات ایجاد شد","2024-12-22 06:14:22","2024-12-22 09:44:22"),
("2447","777","عملیات با Async Request تکمیل شد","2024-12-22 06:14:27","2024-12-22 09:44:27"),
("2448","778","عملیات با Async Request شروع شد","2024-12-22 06:14:35","2024-12-22 09:44:35"),
("2449","778","عملیات با Async Request تکمیل شد","2024-12-22 06:14:38","2024-12-22 09:44:38"),
("2450","779","عملیات با Async Request شروع شد","2024-12-22 06:14:38","2024-12-22 09:44:38"),
("2451","779","عملیات با Async Request تکمیل شد","2024-12-22 06:14:42","2024-12-22 09:44:42"),
("2452","780","عملیات با Async Request شروع شد","2024-12-22 06:14:42","2024-12-22 09:44:42"),
("2453","780","عملیات با Async Request تکمیل شد","2024-12-22 06:14:45","2024-12-22 09:44:45"),
("2454","781","عملیات با Async Request شروع شد","2024-12-22 06:14:45","2024-12-22 09:44:45"),
("2455","781","عملیات با Async Request تکمیل شد","2024-12-22 06:14:48","2024-12-22 09:44:48"),
("2456","782","عملیات با Async Request شروع شد","2024-12-22 06:14:48","2024-12-22 09:44:48"),
("2457","782","عملیات با Async Request تکمیل شد","2024-12-22 06:14:51","2024-12-22 09:44:51"),
("2458","783","عملیات با Async Request شروع شد","2024-12-22 06:14:51","2024-12-22 09:44:51"),
("2459","783","عملیات با Async Request تکمیل شد","2024-12-22 06:14:54","2024-12-22 09:44:54"),
("2460","784","عملیات با Async Request شروع شد","2024-12-22 06:15:01","2024-12-22 09:45:01"),
("2461","784","عملیات با Async Request تکمیل شد","2024-12-22 06:15:04","2024-12-22 09:45:04"),
("2462","785","عملیات با Async Request شروع شد","2024-12-22 06:15:04","2024-12-22 09:45:04"),
("2463","785","عملیات با Async Request تکمیل شد","2024-12-22 06:15:07","2024-12-22 09:45:07"),
("2464","786","عملیات با Async Request شروع شد","2024-12-22 06:15:07","2024-12-22 09:45:07"),
("2465","786","عملیات با Async Request تکمیل شد","2024-12-22 06:15:10","2024-12-22 09:45:10"),
("2466","787","عملیات با Async Request شروع شد","2024-12-22 06:15:10","2024-12-22 09:45:10"),
("2467","787","عملیات با Async Request تکمیل شد","2024-12-22 06:15:13","2024-12-22 09:45:13"),
("2468","788","عملیات با Async Request شروع شد","2024-12-22 06:15:13","2024-12-22 09:45:13"),
("2469","788","عملیات با Async Request تکمیل شد","2024-12-22 06:15:16","2024-12-22 09:45:16"),
("2470","789","عملیات با Async Request شروع شد","2024-12-22 06:15:16","2024-12-22 09:45:16"),
("2471","789","عملیات با Async Request تکمیل شد","2024-12-22 06:15:19","2024-12-22 09:45:19"),
("2472","790","عملیات با Async Request شروع شد","2024-12-22 06:15:19","2024-12-22 09:45:19"),
("2473","790","عملیات با Async Request تکمیل شد","2024-12-22 06:15:22","2024-12-22 09:45:22"),
("2474","814","عملیات ایجاد شد","2024-12-22 06:15:23","2024-12-22 09:45:23"),
("2475","815","عملیات ایجاد شد","2024-12-22 06:15:23","2024-12-22 09:45:23"),
("2476","816","عملیات ایجاد شد","2024-12-22 06:15:23","2024-12-22 09:45:23"),
("2477","791","عملیات با Async Request شروع شد","2024-12-22 06:15:29","2024-12-22 09:45:29"),
("2478","791","عملیات با Async Request تکمیل شد","2024-12-22 06:15:36","2024-12-22 09:45:36"),
("2479","792","عملیات با Async Request شروع شد","2024-12-22 06:15:43","2024-12-22 09:45:43"),
("2480","792","عملیات با Async Request تکمیل شد","2024-12-22 06:15:46","2024-12-22 09:45:46"),
("2481","793","عملیات با Async Request شروع شد","2024-12-22 06:15:46","2024-12-22 09:45:46"),
("2482","793","عملیات با Async Request تکمیل شد","2024-12-22 06:15:49","2024-12-22 09:45:49"),
("2483","794","عملیات با Async Request شروع شد","2024-12-22 06:15:49","2024-12-22 09:45:49"),
("2484","794","عملیات با Async Request تکمیل شد","2024-12-22 06:15:52","2024-12-22 09:45:52"),
("2485","795","عملیات با Async Request شروع شد","2024-12-22 06:15:52","2024-12-22 09:45:52"),
("2486","795","عملیات با Async Request تکمیل شد","2024-12-22 06:15:55","2024-12-22 09:45:55"),
("2487","796","عملیات با Async Request شروع شد","2024-12-22 06:15:55","2024-12-22 09:45:55"),
("2488","796","عملیات با Async Request تکمیل شد","2024-12-22 06:15:58","2024-12-22 09:45:58"),
("2489","797","عملیات با Async Request شروع شد","2024-12-22 06:15:58","2024-12-22 09:45:58"),
("2490","797","عملیات با Async Request تکمیل شد","2024-12-22 06:16:01","2024-12-22 09:46:01"),
("2491","798","عملیات با Async Request شروع شد","2024-12-22 06:16:01","2024-12-22 09:46:01"),
("2492","798","عملیات با Async Request تکمیل شد","2024-12-22 06:16:04","2024-12-22 09:46:04"),
("2493","799","عملیات با WP Cron شروع شد","2024-12-22 06:16:08","2024-12-22 09:46:08"),
("2494","799","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:11","2024-12-22 09:46:11"),
("2495","802","عملیات با WP Cron شروع شد","2024-12-22 06:16:11","2024-12-22 09:46:11"),
("2496","802","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:14","2024-12-22 09:46:14"),
("2497","803","عملیات با WP Cron شروع شد","2024-12-22 06:16:14","2024-12-22 09:46:14"),
("2498","803","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:17","2024-12-22 09:46:17"),
("2499","804","عملیات با WP Cron شروع شد","2024-12-22 06:16:17","2024-12-22 09:46:17"),
("2500","804","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:20","2024-12-22 09:46:20"),
("2501","805","عملیات با WP Cron شروع شد","2024-12-22 06:16:20","2024-12-22 09:46:20"),
("2502","805","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:23","2024-12-22 09:46:23"),
("2503","806","عملیات با WP Cron شروع شد","2024-12-22 06:16:23","2024-12-22 09:46:23"),
("2504","806","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:26","2024-12-22 09:46:26"),
("2505","807","عملیات با WP Cron شروع شد","2024-12-22 06:16:26","2024-12-22 09:46:26"),
("2506","807","عملیات با WP Cron تکمیل شد","2024-12-22 06:16:29","2024-12-22 09:46:29"),
("2507","808","عملیات با Async Request شروع شد","2024-12-22 06:16:52","2024-12-22 09:46:52"),
("2508","817","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2509","818","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2510","819","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2511","820","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2512","821","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2513","822","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2514","823","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2515","824","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2516","825","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2517","826","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2518","827","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2519","828","عملیات ایجاد شد","2024-12-22 06:16:53","2024-12-22 09:46:53"),
("2520","808","عملیات با Async Request تکمیل شد","2024-12-22 06:16:58","2024-12-22 09:46:58"),
("2521","809","عملیات با Async Request شروع شد","2024-12-22 06:17:05","2024-12-22 09:47:05"),
("2522","809","عملیات با Async Request تکمیل شد","2024-12-22 06:17:08","2024-12-22 09:47:08"),
("2523","810","عملیات با Async Request شروع شد","2024-12-22 06:17:08","2024-12-22 09:47:08"),
("2524","800","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2525","811","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2526","812","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2527","813","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2528","814","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2529","815","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2530","816","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2531","817","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2532","818","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2533","819","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2534","820","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2535","821","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2536","822","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2537","823","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2538","824","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2539","825","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2540","826","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2541","827","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2542","828","عملیات لغو شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2543","829","عملیات ایجاد شد","2024-12-22 06:17:11","2024-12-22 09:47:11"),
("2544","810","عملیات با Async Request تکمیل شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2545","811","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2546","812","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2547","813","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2548","800","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2549","801","عملیات با Async Request شروع شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2550","801","عملکرد از طریقAsync Request انجام نشد:Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2551","814","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2552","815","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2553","816","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2554","817","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2555","818","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2556","819","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2557","820","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2558","821","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2559","822","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2560","823","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2561","824","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2562","825","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2563","826","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2564","827","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2565","828","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2566","829","عملیات با Async Request شروع شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2567","830","عملیات ایجاد شد","2024-12-22 06:17:12","2024-12-22 09:47:12"),
("2568","829","عملیات با Async Request تکمیل شد","2024-12-22 06:17:14","2024-12-22 09:47:14"),
("2569","830","عملیات با Async Request شروع شد","2024-12-22 06:17:14","2024-12-22 09:47:14"),
("2570","830","عملیات با Async Request تکمیل شد","2024-12-22 06:17:16","2024-12-22 09:47:16"),
("2571","831","عملیات ایجاد شد","2024-12-22 06:17:17","2024-12-22 09:47:17"),
("2573","833","عملیات ایجاد شد","2024-12-22 06:17:20","2024-12-22 09:47:20"),
("2574","834","عملیات ایجاد شد","2024-12-22 06:17:20","2024-12-22 09:47:20"),
("2575","835","عملیات ایجاد شد","2024-12-22 06:17:20","2024-12-22 09:47:20"),
("2576","836","عملیات ایجاد شد","2024-12-22 06:17:20","2024-12-22 09:47:20"),
("2577","837","عملیات ایجاد شد","2024-12-22 06:17:20","2024-12-22 09:47:20"),
("2578","831","عملیات با Async Request شروع شد","2024-12-22 06:17:23","2024-12-22 09:47:23"),
("2580","833","عملیات لغو شد","2024-12-22 06:17:25","2024-12-22 09:47:25"),
("2581","834","عملیات لغو شد","2024-12-22 06:17:25","2024-12-22 09:47:25"),
("2582","835","عملیات لغو شد","2024-12-22 06:17:25","2024-12-22 09:47:25"),
("2583","836","عملیات لغو شد","2024-12-22 06:17:25","2024-12-22 09:47:25"),
("2584","837","عملیات لغو شد","2024-12-22 06:17:25","2024-12-22 09:47:25"),
("2585","838","عملیات ایجاد شد","2024-12-22 06:17:25","2024-12-22 09:47:25"),
("2586","839","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2587","840","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2588","841","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2589","842","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2590","843","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2591","844","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2592","845","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2593","846","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2594","847","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2595","848","عملیات ایجاد شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2596","831","عملیات با Async Request تکمیل شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2597","833","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2598","834","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2599","835","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2600","836","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2601","837","عملکرد از طریقAsync Requestنادیده گرفته شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2602","838","عملیات با Async Request شروع شد","2024-12-22 06:17:28","2024-12-22 09:47:28"),
("2603","849","عملیات ایجاد شد","2024-12-22 06:17:29","2024-12-22 09:47:29"),
("2604","838","عملیات با Async Request تکمیل شد","2024-12-22 06:17:29","2024-12-22 09:47:29"),
("2605","839","عملیات با Async Request شروع شد","2024-12-22 06:17:29","2024-12-22 09:47:29"),
("2606","850","عملیات ایجاد شد","2024-12-22 06:17:33","2024-12-22 09:47:33"),
("2608","839","عملیات با Async Request تکمیل شد","2024-12-22 06:17:35","2024-12-22 09:47:35"),
("2609","840","عملیات با Async Request شروع شد","2024-12-22 06:17:35","2024-12-22 09:47:35"),
("2610","840","عملیات با Async Request تکمیل شد","2024-12-22 06:17:43","2024-12-22 09:47:43"),
("2611","841","عملیات با Async Request شروع شد","2024-12-22 06:17:43","2024-12-22 09:47:43"),
("2612","841","عملیات با Async Request تکمیل شد","2024-12-22 06:17:48","2024-12-22 09:47:48"),
("2613","842","عملیات با Async Request شروع شد","2024-12-22 06:18:01","2024-12-22 09:48:01"),
("2614","842","عملیات با Async Request تکمیل شد","2024-12-22 06:18:06","2024-12-22 09:48:06"),
("2615","843","عملیات با WP Cron شروع شد","2024-12-22 06:18:17","2024-12-22 09:48:17"),
("2616","843","عملیات با WP Cron تکمیل شد","2024-12-22 06:18:24","2024-12-22 09:48:24"),
("2622","849","عملیات لغو شد","2024-12-22 06:18:45","2024-12-22 09:48:45"),
("2629","857","عملیات ایجاد شد","2024-12-22 06:18:45","2024-12-22 09:48:45"),
("2630","858","عملیات ایجاد شد","2024-12-22 06:18:51","2024-12-22 09:48:51"),
("2631","859","عملیات ایجاد شد","2024-12-22 06:18:51","2024-12-22 09:48:51"),
("2632","844","عملیات با WP Cron شروع شد","2024-12-22 06:19:04","2024-12-22 09:49:04"),
("2633","844","عملیات با WP Cron تکمیل شد","2024-12-22 06:19:09","2024-12-22 09:49:09"),
("2634","845","عملیات با WP Cron شروع شد","2024-12-22 06:19:09","2024-12-22 09:49:09"),
("2635","845","عملیات با WP Cron تکمیل شد","2024-12-22 06:19:13","2024-12-22 09:49:13"),
("2636","846","عملیات با WP Cron شروع شد","2024-12-22 06:19:13","2024-12-22 09:49:13"),
("2637","846","عملیات با WP Cron تکمیل شد","2024-12-22 06:19:18","2024-12-22 09:49:18"),
("2638","847","عملیات با WP Cron شروع شد","2024-12-22 06:19:18","2024-12-22 09:49:18"),
("2639","847","عملیات با WP Cron تکمیل شد","2024-12-22 06:19:24","2024-12-22 09:49:24"),
("2640","860","عملیات ایجاد شد","2024-12-22 06:19:51","2024-12-22 09:49:51"),
("2641","848","عملیات با WP Cron شروع شد","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2642","848","عملکرد از طریقWP Cron انجام نشد:Scheduled action for rocket_job_warmup_url will not be executed as no callbacks are registered.","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2643","850","عملیات با WP Cron شروع شد","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2644","850","عملکرد از طریقWP Cron انجام نشد:Scheduled action for rocket_job_warmup will not be executed as no callbacks are registered.","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2645","857","عملیات با WP Cron شروع شد","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2646","857","عملکرد از طریقWP Cron انجام نشد:Scheduled action for rocket_preload_job_load_initial_sitemap will not be executed as no callbacks are registered.","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2647","858","عملیات با WP Cron شروع شد","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2648","858","عملکرد از طریقWP Cron انجام نشد:Scheduled action for rocket_job_warmup will not be executed as no callbacks are registered.","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2649","859","عملیات با WP Cron شروع شد","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2650","859","عملکرد از طریقWP Cron انجام نشد:Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.","2024-12-22 06:20:06","2024-12-22 09:50:06"),
("2651","860","عملیات با WP Cron شروع شد","2024-12-22 06:21:09","2024-12-22 09:51:09"),
("2652","860","عملیات با WP Cron تکمیل شد","2024-12-22 06:21:09","2024-12-22 09:51:09"),
("2653","861","عملیات ایجاد شد","2024-12-22 06:25:05","2024-12-22 09:55:05"),
("2654","861","عملیات با Async Request شروع شد","2024-12-22 06:26:12","2024-12-22 09:56:12"),
("2655","861","عملیات با Async Request تکمیل شد","2024-12-22 06:26:12","2024-12-22 09:56:12"),
("2656","862","عملیات ایجاد شد","2024-12-22 06:36:15","2024-12-22 10:06:15"),
("2657","862","عملیات با WP Cron شروع شد","2024-12-22 06:37:52","2024-12-22 10:07:52"),
("2658","862","عملیات با WP Cron تکمیل شد","2024-12-22 06:37:52","2024-12-22 10:07:52"),
("2659","863","عملیات ایجاد شد","2024-12-22 06:58:08","2024-12-22 10:28:08"),
("2660","863","عملیات با Async Request شروع شد","2024-12-22 07:00:00","2024-12-22 10:30:00"),
("2661","863","عملیات با Async Request تکمیل شد","2024-12-22 07:00:00","2024-12-22 10:30:00"),
("2662","864","عملیات ایجاد شد","2024-12-22 07:00:01","2024-12-22 10:30:01"),
("2663","864","عملیات با Async Request شروع شد","2024-12-22 07:01:40","2024-12-22 10:31:40"),
("2664","864","عملکرد از طریقAsync Request انجام نشد:Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-12-22 07:01:40","2024-12-22 10:31:40"),
("2665","865","عملیات ایجاد شد","2024-12-22 08:44:51","2024-12-22 12:14:51"),
("2666","866","عملیات ایجاد شد","2024-12-22 08:44:51","2024-12-22 12:14:51"),
("2667","867","عملیات ایجاد شد","2024-12-22 08:44:51","2024-12-22 12:14:51"),
("2668","865","عملیات با WP Cron شروع شد","2024-12-22 08:45:04","2024-12-22 12:15:04"),
("2669","865","عملیات با WP Cron تکمیل شد","2024-12-22 08:45:04","2024-12-22 12:15:04"),
("2670","866","عملیات با WP Cron شروع شد","2024-12-22 08:45:04","2024-12-22 12:15:04"),
("2671","866","عملیات با WP Cron تکمیل شد","2024-12-22 08:45:04","2024-12-22 12:15:04"),
("2672","867","عملیات با WP Cron شروع شد","2024-12-22 08:45:04","2024-12-22 12:15:04"),
("2673","867","عملیات با WP Cron تکمیل شد","2024-12-22 08:45:04","2024-12-22 12:15:04"),
("2674","868","عملیات ایجاد شد","2024-12-22 08:45:23","2024-12-22 12:15:23"),
("2675","868","action started via Async Request","2024-12-22 08:46:45","2024-12-22 12:16:45"),
("2676","868","action complete via Async Request","2024-12-22 08:46:45","2024-12-22 12:16:45"),
("2677","728","action started via WP Cron","2024-12-22 09:29:05","2024-12-22 12:59:05"),
("2678","728","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-12-22 09:29:05","2024-12-22 12:59:05"),
("2679","869","action created","2024-12-22 09:29:05","2024-12-22 12:59:05"),
("2680","729","action started via WP Cron","2024-12-22 09:29:05","2024-12-22 12:59:05"),
("2681","729","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-12-22 09:29:05","2024-12-22 12:59:05"),
("2682","870","action created","2024-12-22 09:29:05","2024-12-22 12:59:05"),
("2683","871","action created","2024-12-22 10:09:29","2024-12-22 13:39:29"),
("2684","871","action started via WP Cron","2024-12-22 10:10:38","2024-12-22 13:40:38"),
("2685","871","action complete via WP Cron","2024-12-22 10:10:38","2024-12-22 13:40:38");

INSERT IGNORE INTO `moyhd_duplicator_backups` VALUES 
("1","20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8","5e6b26f6a1dd90b56819_20241223050605","20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8_5e6b26f6a1dd90b56819_20241223050605_archive.zip","20","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.4.32\",\n    \"VersionPHP\": \"8.1.25\",\n    \"VersionOS\": \"WINNT\",\n    \"Name\": \"20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8\",\n    \"Hash\": \"5e6b26f6a1dd90b56819_20241223050605\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"D:\\/xampp\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/localhost\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8_5e6b26f6a1dd90b56819_20241223050605_scan.json\",\n    \"timer_start\": 1734930411.079512,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u062c\\u06cc \\u062a\\u06cc \\u0627\\u06cc \\u0622\\u0644\",\n    \"Brand_ID\": 10,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"D:\\/xampp\\/htdocs\\/.opcache\",\n            \"D:\\/xampp\\/htdocs\\/.tmb\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/ai1wm-backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/backups-dup-lite\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/backups-dup-pro\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/backupwordpress\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/bps-backup\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/cache\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/content\\/cache\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/contents\\/cache\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/managewp\\/backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/old-cache\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/updraft\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/wfcache\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/wishlist-backup\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/wpvividbackups\",\n            \"D:\\/xampp\\/htdocs\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"D:\\/xampp\\/htdocs\\/.htaccess\",\n            \"D:\\/xampp\\/htdocs\\/.user.ini\",\n            \"D:\\/xampp\\/htdocs\\/php.ini\",\n            \"D:\\/xampp\\/htdocs\\/web.config\",\n            \"D:\\/xampp\\/htdocs\\/wp-config.php\",\n            \"D:\\/xampp\\/htdocs\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8_5e6b26f6a1dd90b56819_20241223050605_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"D:\\/xampp\\/htdocs\",\n        \"Size\": 253805502,\n        \"Dirs\": [],\n        \"DirCount\": 2097,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 11659,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 125694442,\n                        \"bytes\": \"119.87MB\",\n                        \"nodes\": 9352,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 194156725,\n                        \"bytes\": \"185.16MB\",\n                        \"nodes\": 10677,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"D:\\/xampp\\/htdocs\\/wp-snapshots\",\n                    \"D:\\/xampp\\/htdocs\\/.opcache\",\n                    \"D:\\/xampp\\/htdocs\\/.tmb\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/backups-dup-lite\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/backups-dup-pro\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/ai1wm-backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/backupwordpress\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/content\\/cache\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/contents\\/cache\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/managewp\\/backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/old-cache\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/updraft\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/wpvividbackups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/wishlist-backup\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/wfcache\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/bps-backup\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/cache\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 4556642,\n                        \"bytes\": \"4.35MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ui.js\",\n                        \"dir\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                        \"path\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\"\n                    },\n                    {\n                        \"ubytes\": 12581201,\n                        \"bytes\": \"12MB\",\n                        \"nodes\": 1,\n                        \"name\": \"install.mp4\",\n                        \"dir\": \"wp-content\\/uploads\\/2024\\/12\",\n                        \"path\": \"wp-content\\/uploads\\/2024\\/12\\/install.mp4\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"D:\\/xampp\\/htdocs\\/.htaccess\",\n                    \"D:\\/xampp\\/htdocs\\/.user.ini\",\n                    \"D:\\/xampp\\/htdocs\\/php.ini\",\n                    \"D:\\/xampp\\/htdocs\\/web.config\",\n                    \"D:\\/xampp\\/htdocs\\/wp-content\\/debug.log\",\n                    \"D:\\/xampp\\/htdocs\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8_5e6b26f6a1dd90b56819_20241223050605_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"SlfJoquUJbUR2JlxGCqDH6h3qD4+HjeYCk9Xt8jvzN2SZy+NJl8lZm0ZURBZiKv7EsJ2kgHKsvMDfCG65cTNoQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 1,\n            \"isNameUpperCase\": false,\n            \"name\": \"wanted\",\n            \"tablesBaseCount\": 82,\n            \"tablesFinalCount\": 82,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 4344,\n            \"tablesSizeOnDisk\": 13467648,\n            \"tablesList\": {\n                \"moyhd_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 0,\n                    \"size\": 212992\n                },\n                \"moyhd_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"622\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"moyhd_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"moyhd_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"moyhd_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"moyhd_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"moyhd_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"moyhd_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"moyhd_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"moyhd_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_hd_upanel_email_forgot\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_hd_upanel_notifications\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_hd_upanel_notifications_read\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_hd_upanel_sidemenu\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_hd_upanel_sms_providers\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_hd_upanel_sms_provider_name\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_hd_upanel_tickets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_imagify_files\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"moyhd_imagify_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_oping_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_oping_backup_services\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_options\": {\n                    \"inaccurateRows\": \"920\",\n                    \"insertedRows\": 0,\n                    \"size\": 3653632\n                },\n                \"moyhd_postmeta\": {\n                    \"inaccurateRows\": \"1734\",\n                    \"insertedRows\": 0,\n                    \"size\": 3702784\n                },\n                \"moyhd_posts\": {\n                    \"inaccurateRows\": \"120\",\n                    \"insertedRows\": 0,\n                    \"size\": 1556480\n                },\n                \"moyhd_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"moyhd_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_revslider_sliders7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_revslider_slides7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_rtl_rsm_logs\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_snippets\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"moyhd_termmeta\": {\n                    \"inaccurateRows\": \"71\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_terms\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_term_relationships\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_term_taxonomy\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_usermeta\": {\n                    \"inaccurateRows\": \"88\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"moyhd_wc_admin_notes\": {\n                    \"inaccurateRows\": \"82\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"moyhd_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"111\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"moyhd_wc_category_lookup\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"moyhd_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"moyhd_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"moyhd_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"moyhd_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"moyhd_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"moyhd_woocommerce_ir\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_woocommerce_ir_sms_archive\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_woocommerce_ir_sms_contacts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"moyhd_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"moyhd_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"moyhd_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"moyhd_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.4.32\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8_5e6b26f6a1dd90b56819_20241223050605_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"D:\\/xampp\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\\/20241223_d8b3d8b1d988d8b1d988d8a7d986d8aad8afd8_5e6b26f6a1dd90b56819_20241223050605_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1734930414,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"moyhd_users\",\n            \"moyhd_usermeta\",\n            \"moyhd_actionscheduler_actions\",\n            \"moyhd_actionscheduler_claims\",\n            \"moyhd_actionscheduler_groups\",\n            \"moyhd_actionscheduler_logs\",\n            \"moyhd_commentmeta\",\n            \"moyhd_comments\",\n            \"moyhd_duplicator_backups\",\n            \"moyhd_duplicator_entities\",\n            \"moyhd_e_events\",\n            \"moyhd_e_notes\",\n            \"moyhd_e_notes_users_relations\",\n            \"moyhd_e_submissions\",\n            \"moyhd_e_submissions_actions_log\",\n            \"moyhd_e_submissions_values\",\n            \"moyhd_hd_upanel_email_forgot\",\n            \"moyhd_hd_upanel_notifications\",\n            \"moyhd_hd_upanel_notifications_read\",\n            \"moyhd_hd_upanel_sidemenu\",\n            \"moyhd_hd_upanel_sms_providers\",\n            \"moyhd_hd_upanel_sms_provider_name\",\n            \"moyhd_hd_upanel_tickets\",\n            \"moyhd_imagify_files\",\n            \"moyhd_imagify_folders\",\n            \"moyhd_links\",\n            \"moyhd_oping_backups\",\n            \"moyhd_oping_backup_services\",\n            \"moyhd_options\",\n            \"moyhd_postmeta\",\n            \"moyhd_posts\",\n            \"moyhd_revslider_css\",\n            \"moyhd_revslider_layer_animations\",\n            \"moyhd_revslider_navigations\",\n            \"moyhd_revslider_sliders\",\n            \"moyhd_revslider_sliders7\",\n            \"moyhd_revslider_slides\",\n            \"moyhd_revslider_slides7\",\n            \"moyhd_revslider_static_slides\",\n            \"moyhd_rtl_rsm_logs\",\n            \"moyhd_snippets\",\n            \"moyhd_termmeta\",\n            \"moyhd_terms\",\n            \"moyhd_term_relationships\",\n            \"moyhd_term_taxonomy\",\n            \"moyhd_wc_admin_notes\",\n            \"moyhd_wc_admin_note_actions\",\n            \"moyhd_wc_category_lookup\",\n            \"moyhd_wc_customer_lookup\",\n            \"moyhd_wc_download_log\",\n            \"moyhd_wc_orders\",\n            \"moyhd_wc_orders_meta\",\n            \"moyhd_wc_order_addresses\",\n            \"moyhd_wc_order_coupon_lookup\",\n            \"moyhd_wc_order_operational_data\",\n            \"moyhd_wc_order_product_lookup\",\n            \"moyhd_wc_order_stats\",\n            \"moyhd_wc_order_tax_lookup\",\n            \"moyhd_wc_product_attributes_lookup\",\n            \"moyhd_wc_product_download_directories\",\n            \"moyhd_wc_product_meta_lookup\",\n            \"moyhd_wc_rate_limits\",\n            \"moyhd_wc_reserved_stock\",\n            \"moyhd_wc_tax_rate_classes\",\n            \"moyhd_wc_webhooks\",\n            \"moyhd_woocommerce_api_keys\",\n            \"moyhd_woocommerce_attribute_taxonomies\",\n            \"moyhd_woocommerce_downloadable_product_permissions\",\n            \"moyhd_woocommerce_ir\",\n            \"moyhd_woocommerce_ir_sms_archive\",\n            \"moyhd_woocommerce_ir_sms_contacts\",\n            \"moyhd_woocommerce_log\",\n            \"moyhd_woocommerce_order_itemmeta\",\n            \"moyhd_woocommerce_order_items\",\n            \"moyhd_woocommerce_payment_tokenmeta\",\n            \"moyhd_woocommerce_payment_tokens\",\n            \"moyhd_woocommerce_sessions\",\n            \"moyhd_woocommerce_shipping_zones\",\n            \"moyhd_woocommerce_shipping_zone_locations\",\n            \"moyhd_woocommerce_shipping_zone_methods\",\n            \"moyhd_woocommerce_tax_rates\",\n            \"moyhd_woocommerce_tax_rate_locations\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1734930411.105169,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 4345,\n            \"tables\": {\n                \"moyhd_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_email_forgot\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_notifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_notifications_read\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_sidemenu\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_sms_providers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_sms_provider_name\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_hd_upanel_tickets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_imagify_files\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_imagify_folders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_oping_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_oping_backup_services\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_sliders7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_slides7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_rtl_rsm_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_snippets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_ir\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_ir_sms_archive\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_ir_sms_contacts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"moyhd_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 6,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 05:06:05\",\n    \"updated\": \"2024-12-23 05:06:54\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.20","2024-12-23 05:06:05","2024-12-23 05:06:54");

INSERT IGNORE INTO `moyhd_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": true,\n    \"uninstall_packages\": true,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"info@wantedrp.ir\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"info@wantedrp.ir\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"http\",\n    \"custom_ajax_url\": \"http:\\/\\/localhost\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"withhash\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1734929805,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 05:06:05\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 05:06:05"),
("2","DUP_PRO_Secure_Global_Entity","","","","","","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 04:59:52\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 04:59:52"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"ZcBAYwgdigYkoc7YXrYo1\\/cxvuTX2uVT8W9NCbGdFqCeLRhY7JcuOYFch40nV1d0604YoGksOkUmE0auGnRQMocvTHYVp6xQ\\/89Tk6ggkpUrurhW4u9prlO2AkicTSLJ+XsHCPc7ikQSX73dxNWSpzIxS+6VWE8CL5lUq01RMjOr8yIjTj+6FJzTlPpiJ58mJ0IDV3kWHip2c6xiqkO6XwDKMoaLQhL0zxMwoY5GdtJ\\/Eju\\/phkowT9xviIMKUfks1EZlRpVnFQ=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 04:56:44\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 04:56:44"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 04:56:44\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 04:56:44"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"xYYygU9p34P8zFU52XmOSTJa4fFQjjKiELcE9vtfsVGpm0mQU3VMP8sb5o7wOzLQmxZcXmEMjbHURTHj6iYJSA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": \"10\",\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 05:05:32\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 05:05:32"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"qlFLyyzAE0x3cXABjOb3mHty3ve4MlkjmHQ5hZlvgmYB\\/pt6iYMlR6zVTMT6Czmg+8cAXzWr3CTOQQ9Ppksu6g==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": 10,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 05:06:05\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 05:06:05"),
("7","Dynamic_Entity","","","","","","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 04:56:45\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 04:56:45"),
("8","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"x14bZ6OMBevJwA6NFJu53c45SRvl5Gqp+db2gTiRZo4i5Ln95ybV\\/tK7weAFfyBFOrYvMWDzeKpdRvs71Z7z7w==\",\n    \"status\": \"ASzI4Y9UIaGbkyHwe5PjNSvXcL+HrcGC19notpqUB4HBMqiRhqkrypzUch5hf1k2ic+ssSi+YPc6jNC3lKOBFl8dqm5SPsrt\",\n    \"type\": \"weSZMUwXZyAhTDriHAO2e\\/T0XPSSuxxcDr+irbb9WyJIvHGpu8Tc1bIhCFSVcy5a3MXxn4M7ZXbDiWLOSqiKtJPW\\/Pg9Qdhc\",\n    \"data\": \"dR4L3+Rsuo4I6DBSoM0HEPMgu0qVMACvAvYGZKbjdKUFmxfUUhiyC8q8mpwyId4lJX70uFlCL2vfpoJM9a+8zpohQBWYEKGcLXirCqlFGIJzEPGRPSAFe3KvXgCW3hAAPJurM+EAbtVHUNTku5zKo3RB5qwS\\/7mI\\/XxlhsA32PLj4\\/uwd0oI8m51cgrWrqey6cB6Q9di\\/a3arDZ44I9Ck9tIzfgIl0xZjXm0gdUA3FZtEuvN1bk1qyV+9LhZQi9r1v6Mc\\/3tIiEfn06OlpwHKaofW0o21uZu97k4oPMfAcAS26LYWcZTY+fT9XiQr3y3yz0nujtpRZPCdfpPhwFwXafrGJ0Lv8uEFhXly4Ms09hZAapzNDsSat0+6ateJwa1eMfQ3z6eMuDTbl5WBs9DP2FHq916xmQDLAuo7QChvGQ=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:44\",\n    \"updated\": \"2024-12-23 05:06:54\"\n}","4.5.20","2024-12-23 04:56:44","2024-12-23 05:06:54"),
("9","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1734930409,\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 04:56:46\",\n    \"updated\": \"2024-12-23 05:06:49\"\n}","4.5.20","2024-12-23 04:56:46","2024-12-23 05:06:49"),
("10","DUP_PRO_Brand_Entity","","","","","","{\n    \"name\": \"\\u062c\\u06cc \\u062a\\u06cc \\u0627\\u06cc \\u0622\\u0644\",\n    \"notes\": \"\",\n    \"editable\": true,\n    \"logo\": \"<i class=\\\"fa fa-cogs\\\"><\\/i> \\u0628\\u0633\\u062a\\u0647 \\u0646\\u0635\\u0628\\u06cc \\u062c\\u06cc \\u062a\\u06cc \\u0627\\u06cc \\u0622\\u0644\",\n    \"attachments\": [\n        \"\"\n    ],\n    \"default\": false,\n    \"brandMode\": 1,\n    \"active\": false,\n    \"style\": [],\n    \"id\": 10,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.20\",\n    \"created\": \"2024-12-23 05:03:45\",\n    \"updated\": \"2024-12-23 05:03:45\"\n}","4.5.20","2024-12-23 05:03:45","2024-12-23 05:03:45");

INSERT IGNORE INTO `moyhd_hd_upanel_notifications_read` VALUES 
("1","1",NULL,NULL);

INSERT IGNORE INTO `moyhd_hd_upanel_sidemenu` VALUES 
("1","1","[\\\"dashboard\\\",\\\"notifications\\\",\\\"tickets\\\",\\\"orders\\\",null,\\\"downloads\\\",\\\"divider\\\",\\\"settings\\\",\\\"logout\\\",\\\"link_1\\\",\\\"link_2\\\",\\\"link_3\\\",\\\"link_4\\\",\\\"link_5\\\",\\\"html_1\\\",\\\"html_2\\\",\\\"html_3\\\",\\\"html_4\\\",\\\"html_5\\\",\\\"addresses\\\"]","{\"settings\":\"\",\"all_settings\":\"\",\"dashboard_label\":\"\\u062f\\u0627\\u0634\\u0628\\u0648\\u0631\\u062f\",\"dashboard_active\":\"on\",\"welcome_card_active\":\"on\",\"welcome_label\":\"\\u06a9\\u0627\\u0631\\u0628\\u0631 \\u06af\\u0631\\u0627\\u0645\\u06cc name \\u0628\\u0647 \\u067e\\u0646\\u0644 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u06cc \\u062e\\u0648\\u0634 \\u0622\\u0645\\u062f\\u06cc\\u062f.\",\"calendar_card_active\":\"on\",\"calendar_img\":\"\",\"jalali_card_active\":\"on\",\"georgian_card_active\":\"on\",\"comments_card_active\":\"on\",\"comments_background\":\"#00ffb2\",\"settings_card_active\":\"on\",\"orders_card_active\":\"on\",\"register_card_active\":\"on\",\"register_background\":\"#4b00b0\",\"register_card_show\":\"2\",\"address_card_active\":\"on\",\"log_out_card_active\":\"on\",\"orders_label\":\"\\u0633\\u0641\\u0627\\u0631\\u0634 \\u0647\\u0627\",\"orders_active\":\"on\",\"address_label\":\"\\u0622\\u062f\\u0631\\u0633 \\u0647\\u0627\",\"notifications_label\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0647\\u0627\",\"notifications_active\":\"on\",\"downloads_label\":\"\\u062f\\u0627\\u0646\\u0644\\u0648\\u062f \\u0647\\u0627\",\"settings_label\":\"\\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a\",\"settings_active\":\"on\",\"logout_label\":\"\\u062e\\u0631\\u0648\\u062c \\u0627\\u0632 \\u062d\\u0633\\u0627\\u0628\",\"logout_active\":\"on\",\"divider_label\":\"30\",\"divider_active\":\"on\",\"link_1_label\":\"\\u0642\\u0648\\u0627\\u0646\\u06cc\\u0646 \\u0648 \\u0645\\u0642\\u0631\\u0631\\u0627\\u062a\",\"link_1_active\":\"on\",\"link_1_link\":\"\\/rules\\/\",\"link_1_newtab\":\"on\",\"link_2_label\":\"\\u0644\\u06cc\\u0646\\u06a9 \\u062f\\u0648\",\"link_2_link\":\"link\",\"link_2_newtab\":\"on\",\"link_3_label\":\"\\u0644\\u06cc\\u0646\\u06a9 \\u0633\\u0647\",\"link_3_link\":\"link\",\"link_3_newtab\":\"on\",\"link_4_label\":\"\\u0644\\u06cc\\u0646\\u06a9 \\u0686\\u0647\\u0627\\u0631\",\"link_4_link\":\"link\",\"link_4_newtab\":\"on\",\"link_5_label\":\"\\u0644\\u06cc\\u0646\\u06a9 \\u067e\\u0646\\u062c\",\"link_5_link\":\"link\",\"link_5_newtab\":\"on\",\"html_1_label\":\"\\u0645\\u0646\\u0648 \\u06cc\\u06a9\",\"html_1_link\":\"menu-1\",\"html_2_label\":\"\\u0645\\u0646\\u0648 \\u062f\\u0648\",\"html_2_link\":\"menu-2\",\"html_3_label\":\"\\u0645\\u0646\\u0648 \\u0633\\u0647\",\"html_3_link\":\"menu-3\",\"html_4_label\":\"\\u0645\\u0646\\u0648 \\u0686\\u0647\\u0627\\u0631\",\"html_4_link\":\"menu-4\",\"html_5_label\":\"\\u0645\\u0646\\u0648 \\u067e\\u0646\\u062c\",\"html_5_link\":\"menu-5\",\"tickets_label\":\"\\u067e\\u0634\\u062a\\u06cc\\u0628\\u0627\\u0646\\u06cc\",\"tickets_active\":\"on\",\"membership_label\":\"\",\"submit\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u062a\\u063a\\u06cc\\u06cc\\u0631\\u0627\\u062a\",\"address_active\":\"off\",\"downloads_active\":\"off\",\"link_2_active\":\"off\",\"link_3_active\":\"off\",\"link_4_active\":\"off\",\"link_5_active\":\"off\",\"html_1_active\":\"off\",\"html_2_active\":\"off\",\"html_3_active\":\"off\",\"html_4_active\":\"off\",\"html_5_active\":\"off\"}","{\"url\":\"panel\",\"template\":\"0\",\"panel_url\":\"panel\",\"panel_title\":\"\\u067e\\u0646\\u0644 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u06cc\",\"no_index\":\"on\",\"color\":\"#2052ff\",\"color_dark\":\"#ffb81f\",\"main_logo\":\"https:\\/\\/wantedrp.ir\\/wp-content\\/uploads\\/2024\\/06\\/WantedRp.png\",\"main_logo_dark\":\"\",\"login_background\":\"\",\"upanel_login_content\":\"\",\"upanel_login_content_color\":\"#ffffff\",\"copyright\":\"\\u00a9\\u06f1\\u06f4\\u06f03 - \\u062a\\u0645\\u0627\\u0645\\u06cc \\u062d\\u0642\\u0648\\u0642 \\u0645\\u0627\\u062f\\u06cc \\u0648 \\u0645\\u0639\\u0646\\u0648\\u06cc \\u0645\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0647 \\u062a\\u06cc\\u0645 \\u0648\\u0627\\u0646\\u062a\\u062f \\u0631\\u0648\\u0644 \\u067e\\u0644\\u06cc \\u0645\\u06cc\\u200c\\u0628\\u0627\\u0634\\u062f.\",\"dark_mode\":\"on\",\"facebook\":\"\",\"twitter\":\"\",\"instagram\":\"\",\"telegram_active\":\"on\",\"telegram\":\"https:\\/\\/t.me\\/wanted_roleplay\",\"whatsapp\":\"support@gtaall.ir\",\"avatar\":\"on\",\"home_link\":\"on\",\"account\":\"on\",\"logout_popup_image\":\"on\",\"basket_image_dashboard\":\"on\",\"sms\":\"4\",\"sms-id\":[\"1\",\"2\",\"3\",\"8\",\"4\",\"7\",\"6\",\"9\",\"5\"],\"username\":[\"\",\"\",\"\",\"\",\"09215979557\",\"\",\"\",\"\",\"\"],\"password\":[\"\",\"\",\"\",\"\",\"007ecd5b-8c8b-4068-930e-cf415aa09761\",\"\",\"\",\"\",\"\"],\"token\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"number\":[\"\",\"\",\"\",\"\",\"50004001979557\",\"\",\"\",\"\",\"\"],\"reset_password_pattern\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"sms_content\":\"\",\"sms_content_reset_password\":\"\",\"login_page\":\"on\",\"login_sms\":\"on\",\"register_sms\":\"on\",\"login_by_mobile\":\"on\",\"register_by_mobile\":\"on\",\"register_firstname\":\"on\",\"register_lastname\":\"on\",\"register_username\":\"on\",\"register_mobile\":\"on\",\"departments\":\"%D9%81%D8%B1%D9%88%D8%B4+%D9%88+%D8%AA%D9%85%D8%AF%DB%8C%D8%AF%2C%D9%BE%DB%8C%DA%AF%DB%8C%D8%B1%DB%8C+%D8%AE%D8%B1%DB%8C%D8%AF%2C%D8%A7%D8%B9%D9%84%D8%A7%D9%85+%D8%A8%D8%A7%DA%AF\",\"departmets-\":[\"\\u0639\\u0636\\u0648\\u06cc\\u062a \\u062f\\u0631 \\u0627\\u0633\\u062a\\u0641\"],\"ticket_expire\":\"3\",\"email_host\":\"\",\"email_encode\":\"3\",\"email_smtp\":\"\",\"email_username\":\"\",\"email_password\":\"\",\"email_email\":\"\",\"email_name\":\"\",\"submit\":\"\\u0630\\u062e\\u06cc\\u0631\\u0647 \\u062a\\u063a\\u06cc\\u06cc\\u0631\\u0627\\u062a\",\"facebook_active\":\"off\",\"twitter_active\":\"off\",\"instagram_active\":\"off\",\"whatsapp_active\":\"off\",\"login_by_email\":\"off\",\"login_by_username\":\"off\",\"register_by_email\":\"off\",\"register_by_username\":\"off\",\"register_email\":\"off\"}");

INSERT IGNORE INTO `moyhd_hd_upanel_sms_providers` VALUES 
("1","1","کاوه نگار","","","","","1","","0","5","2024-12-21 11:06:02","1"),
("2","2","کاوه نگار (اعتبارسنجی-OTP)","","","","","0","","0","5","2024-12-21 11:06:02","2"),
("3","3","فراز","","","","","0","","0","5","2024-12-21 11:06:02","3"),
("4","4","ملی پیامک","09215979557","007ecd5b-8c8b-4068-930e-cf415aa09761","","","0","50004001979557","1","5","2024-12-21 11:06:02","5"),
("5","5","رایگان پیامک","","","","","0","","0","5","2024-12-21 11:06:02","9"),
("6","6","sms.ir","","","","","1","","0","5","2024-12-21 11:06:02","7"),
("7","7","ملی پیامک (اعتبارسنجی-OTP)","","","","","1","","0","5","2024-12-21 11:06:02","6"),
("8","8"," فراز (اعتبارسنجی-OTP)","","","","","1","","0","5","2024-12-21 11:06:02","4"),
("9","9","sms.ir (اعتبارسنجی-OTP)","","","","","1","","0","5","2024-12-21 11:06:02","8");

INSERT IGNORE INTO `moyhd_hd_upanel_sms_provider_name` VALUES 
("1","کاوه نگار","kavenegarRest","2024-12-21 11:06:02"),
("2","کاوه نگار (اعتبارسنجی-OTP)","kavenegarUtp","2024-12-21 11:06:02"),
("3","فراز","farazsmsRest","2024-12-21 11:06:02"),
("4","ملی پیامک","melipayamakRest","2024-12-21 11:06:02"),
("5","رایگان پیامک","rayeganSMSRest","2024-12-21 11:06:02"),
("6","(پنل جدید) sms.ir","smsirRest","2024-12-21 11:06:02"),
("7","ملی پیامک (اعتبارسنجی-OTP)","melipayamakUtp","2024-12-21 11:06:02"),
("8","فراز (اعتبارسنجی-OTP)","farazSmsUtp","2024-12-21 11:06:02"),
("9","(اعتبارسنجی-OTP) sms.ir","smsirUtp","2024-12-21 11:06:02");

INSERT IGNORE INTO `moyhd_imagify_files` VALUES 
("1","1","2024-10-29 07:43:30","{{THEMES}}/xtra/screenshot.png","d18512d7b4d7a4b0322064f4f0561652","image/png","0","1200","900","6303",NULL,NULL,NULL,NULL,NULL,NULL),
("2","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/dashboard.png","e089ba667f3ad85d8c11278ef43eede0","image/png","0","100","100","3522",NULL,NULL,NULL,NULL,NULL,NULL),
("3","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/options.png","63b84969d293b45a8e833eac246a34a3","image/png","0","64","64","2688",NULL,NULL,NULL,NULL,NULL,NULL),
("4","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/support.png","4cf2a525d359a25f84b7072d6537b004","image/png","0","64","64","2529",NULL,NULL,NULL,NULL,NULL,NULL),
("5","1","2024-10-29 07:43:30","{{THEMES}}/xtra/assets/img/envato.png","c82fc97f88a3610ef2b9e8a68c07d9af","image/png","0","400","80","6209",NULL,NULL,NULL,NULL,NULL,NULL),
("7","1","2024-10-29 07:43:30","{{THEMES}}/xtra/assets/img/screenshot.png","a9ae04ee5c1eb8f1b506ae1e47911700","image/png","0","1200","900","16834",NULL,NULL,NULL,NULL,NULL,NULL),
("8","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/tick.png","791193e711e34a8ea59a3722797977d8","image/png","0","110","110","3945",NULL,NULL,NULL,NULL,NULL,NULL),
("9","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/revslider.jpg","b2189078f2e072c822833679bd04165d","image/jpeg","0","96","96","4850",NULL,NULL,NULL,NULL,NULL,NULL),
("10","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/feedback.png","c1f9771ee0e8cdf59b0650bb8f983b63","image/png","0","64","64","2506",NULL,NULL,NULL,NULL,NULL,NULL),
("11","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/codevz-plus.jpg","8e45bfc2a623212a8871988bcbf23cdb","image/jpeg","0","96","96","3215",NULL,NULL,NULL,NULL,NULL,NULL),
("12","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/importer_page.png","60db6a85c32f9532026032cdc8d7b95c","image/png","0","64","64","1761",NULL,NULL,NULL,NULL,NULL,NULL),
("13","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/autoptimize.jpg","a7f1c78bef0e2749da722161b081c3af","image/jpeg","0","96","96","5210",NULL,NULL,NULL,NULL,NULL,NULL),
("14","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/importing.png","4d0847186356ea02269bb1b84dd07ff2","image/png","0","160","160","4339",NULL,NULL,NULL,NULL,NULL,NULL),
("15","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/changelog.png","362698508329050925cf3cdd74e659cf","image/png","0","64","64","1966",NULL,NULL,NULL,NULL,NULL,NULL),
("16","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/uninstall.png","9e6acdf69ed0a194d54e6b879a9be0f2","image/png","0","64","64","2080",NULL,NULL,NULL,NULL,NULL,NULL),
("17","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/status.png","f10cd9aa79b61b5ae99ee6464953d205","image/png","0","64","64","1942",NULL,NULL,NULL,NULL,NULL,NULL),
("18","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/contact-form-7.jpg","b7d9115df9b5d95eeb093e052874a60d","image/jpeg","0","96","96","5437",NULL,NULL,NULL,NULL,NULL,NULL),
("19","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/woocommerce.jpg","f634fc9d0c73ee127b56ef3750ec9aaa","image/jpeg","0","96","96","4001",NULL,NULL,NULL,NULL,NULL,NULL),
("20","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/importer.png","3c9baa6f9bd15e22dd18b3d6d1d3d644","image/png","0","64","64","2562",NULL,NULL,NULL,NULL,NULL,NULL),
("21","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/docs.png","9a33727eaecfd20fe0d86e4760249255","image/png","0","64","64","1770",NULL,NULL,NULL,NULL,NULL,NULL),
("22","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/videos.png","b18b992933ce7cd0e113ce3c9a67de4a","image/png","0","64","64","2151",NULL,NULL,NULL,NULL,NULL,NULL),
("23","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/faq.png","7c24df452b818bc3eb67cfb5db3d3518","image/png","0","64","64","2292",NULL,NULL,NULL,NULL,NULL,NULL),
("24","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/supercache.jpg","a38b5d1141d4c79b34b48c79d1a24bff","image/jpeg","0","96","96","3094",NULL,NULL,NULL,NULL,NULL,NULL),
("25","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/certificate.png","55ce7a07ec60a0bc6a5e253d56ec42ac","image/png","0","70","70","2427",NULL,NULL,NULL,NULL,NULL,NULL),
("26","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/error.png","7dc48a6db4bd9a6a183819a50844cb6e","image/png","0","110","110","3327",NULL,NULL,NULL,NULL,NULL,NULL),
("27","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/plugins.png","735daf39fb9fb9788759be40c5a289e4","image/png","0","64","64","2525",NULL,NULL,NULL,NULL,NULL,NULL),
("28","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/activation.png","04a316bd03cb000ce56c6fd641a62481","image/png","0","64","64","1773",NULL,NULL,NULL,NULL,NULL,NULL),
("29","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/elementor.jpg","ce8724e7d284ba07673162c4d3ea53b9","image/jpeg","0","96","96","3481",NULL,NULL,NULL,NULL,NULL,NULL),
("30","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/js_composer.jpg","98c0afb69460f0e5e761f49c7cc690ec","image/jpeg","0","96","96","3006",NULL,NULL,NULL,NULL,NULL,NULL),
("31","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/activated.png","81767ff6ef1ad0603fe4d4d494c9b456","image/png","0","64","64","1828",NULL,NULL,NULL,NULL,NULL,NULL),
("32","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/warning.png","299aaab52d7f8e47b97ddf4f08cce6f9","image/png","0","110","110","3376",NULL,NULL,NULL,NULL,NULL,NULL),
("33","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/ewww-image-optimizer.jpg","91d5e1eb3d6bee290c7571159f38b4ab","image/jpeg","0","96","96","4226",NULL,NULL,NULL,NULL,NULL,NULL),
("34","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/bg.png","3d2110f2820a5dd1f9c41b411e6d1c10","image/png","0","800","350","43903",NULL,NULL,NULL,NULL,NULL,NULL),
("69","1","2024-09-15 12:30:34","{{THEMES}}/xtra/assets/img/litespeed-cache.jpg","775022df46b4ef9e8f4a3a529418199c","image/jpeg","0","96","96","10699",NULL,NULL,NULL,NULL,NULL,NULL);

INSERT IGNORE INTO `moyhd_imagify_folders` VALUES 
("1","{{THEMES}}/xtra/","1");

INSERT IGNORE INTO `moyhd_oping_backups` VALUES 
("1","1","2",NULL,NULL,"1",NULL,"0","2024-12-21 15:04:48","2024-12-21 15:04:48");

INSERT IGNORE INTO `moyhd_options` VALUES 
("1","siteurl","http://localhost","yes"),
("2","home","http://localhost","yes"),
("3","blogname","سرور وانتد رول پلی","yes"),
("4","blogdescription","برترین سرور هوی آرپی ام تی ای","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","info@wantedrp.ir","yes"),
("7","start_of_week","6","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","1","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","","yes"),
("21","default_pingback_flag","","yes"),
("22","posts_per_page","4","yes"),
("23","date_format","Y-m-d","yes"),
("24","time_format","H:i","yes"),
("25","links_updated_date_format","j F Y H:i","yes"),
("26","comment_moderation","1","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:299:{s:11:\"projects/?$\";s:29:\"index.php?post_type=portfolio\";s:41:\"projects/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:36:\"projects/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:28:\"projects/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:53:\"projects/cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_cat=$matches[1]&feed=$matches[2]\";s:48:\"projects/cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_cat=$matches[1]&feed=$matches[2]\";s:29:\"projects/cat/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_cat=$matches[1]&embed=true\";s:41:\"projects/cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_cat=$matches[1]&paged=$matches[2]\";s:23:\"projects/cat/([^/]+)/?$\";s:35:\"index.php?portfolio_cat=$matches[1]\";s:54:\"projects/tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:49:\"projects/tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:30:\"projects/tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:42:\"projects/tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:24:\"projects/tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:36:\"projects/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"projects/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"projects/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"projects/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"projects/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:29:\"projects/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:49:\"projects/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:44:\"projects/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:37:\"projects/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:44:\"projects/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:45:\"projects/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"projects/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:51:\"projects/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"projects/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"projects/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"projects/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"projects/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:25:\"projects/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"projects/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"projects/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"projects/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"product-size-guide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"product-size-guide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"product-size-guide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"product-size-guide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"product-size-guide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"product-size-guide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"product-size-guide/([^/]+)/embed/?$\";s:50:\"index.php?codevz_size_guide=$matches[1]&embed=true\";s:39:\"product-size-guide/([^/]+)/trackback/?$\";s:44:\"index.php?codevz_size_guide=$matches[1]&tb=1\";s:47:\"product-size-guide/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?codevz_size_guide=$matches[1]&paged=$matches[2]\";s:54:\"product-size-guide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?codevz_size_guide=$matches[1]&cpage=$matches[2]\";s:55:\"product-size-guide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?codevz_size_guide=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"product-size-guide/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?codevz_size_guide=$matches[1]&wc-api=$matches[3]\";s:61:\"product-size-guide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"product-size-guide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"product-size-guide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"product-size-guide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"product-size-guide/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?codevz_size_guide=$matches[1]&page=$matches[2]\";s:35:\"product-size-guide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product-size-guide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product-size-guide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product-size-guide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product-size-guide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product-size-guide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"product-faq/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"product-faq/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"product-faq/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"product-faq/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"product-faq/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"product-faq/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"product-faq/([^/]+)/embed/?$\";s:43:\"index.php?codevz_faq=$matches[1]&embed=true\";s:32:\"product-faq/([^/]+)/trackback/?$\";s:37:\"index.php?codevz_faq=$matches[1]&tb=1\";s:40:\"product-faq/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?codevz_faq=$matches[1]&paged=$matches[2]\";s:47:\"product-faq/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?codevz_faq=$matches[1]&cpage=$matches[2]\";s:48:\"product-faq/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?codevz_faq=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"product-faq/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?codevz_faq=$matches[1]&wc-api=$matches[3]\";s:54:\"product-faq/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"product-faq/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"product-faq/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"product-faq/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"product-faq/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?codevz_faq=$matches[1]&page=$matches[2]\";s:28:\"product-faq/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"product-faq/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"product-faq/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"product-faq/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"product-faq/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"product-faq/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"product-brand/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?codevz_brands=$matches[1]&feed=$matches[2]\";s:49:\"product-brand/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?codevz_brands=$matches[1]&feed=$matches[2]\";s:30:\"product-brand/([^/]+)/embed/?$\";s:46:\"index.php?codevz_brands=$matches[1]&embed=true\";s:42:\"product-brand/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?codevz_brands=$matches[1]&paged=$matches[2]\";s:24:\"product-brand/([^/]+)/?$\";s:35:\"index.php?codevz_brands=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=836&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:27:\"(.?.+?)/tracking(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&tracking=$matches[3]\";s:27:\"(.?.+?)/wishlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&wishlist=$matches[3]\";s:25:\"(.?.+?)/viewed(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&viewed=$matches[3]\";s:26:\"(.?.+?)/reviews(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&reviews=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:12:{i:0;s:31:\"code-snippets/code-snippets.php\";i:1;s:27:\"codevz-plus/codevz-plus.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:31:\"creative-wp-login-page/cwlp.php\";i:4;s:63:\"display-name-author-permalink/display-name-author-permalink.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:31:\"elementor-pro/elementor-pro.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:19:\"imagify/imagify.php\";i:9;s:30:\"parsi-font/mw-font-changer.php\";i:10;s:45:\"simple-local-avatars/simple-local-avatars.php\";i:11;s:56:\"woo-checkout-field-editor-pro/checkout-form-designer.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","xtra","yes"),
("41","stylesheet","xtra","yes"),
("42","comment_registration","","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","58975","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","0","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:3:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:6:{i:0;b:0;s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:25:\"loginpress/loginpress.php\";a:2:{i:0;s:16:\"WPBRIGADE_Logger\";i:1;s:18:\"log_uninstallation\";}s:62:\"all-in-one-wp-security-and-firewall-premium/aiowps-premium.php\";a:2:{i:0;s:14:\"AIOWPS_PREMIUM\";i:1;s:17:\"uninstall_handler\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}s:45:\"simple-local-avatars/simple-local-avatars.php\";s:30:\"simple_local_avatars_uninstall\";}","auto"),
("80","timezone_string","Asia/Tehran","yes"),
("81","page_for_posts","521","yes"),
("82","page_on_front","836","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","1169","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","22219","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1750137607","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","wp_force_deactivated_plugins","a:0:{}","off"),
("99","wp_attachment_pages_enabled","0","yes"),
("100","initial_db_version","57155","yes"),
("101","moyhd_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:130:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}","yes"),
("102","fresh_site","0","off"),
("103","WPLANG","fa_IR","yes"),
("104","user_count","1","no"),
("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes"),
("106","sidebars_widgets","a:15:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:7:\"primary\";a:4:{i:0;s:8:\"search-2\";i:1;s:11:\"tag_cloud-2\";i:2;s:17:\"codevzpostslist-2\";i:3;s:12:\"categories-2\";}s:9:\"secondary\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:8:\"footer-6\";a:0:{}s:14:\"offcanvas_area\";a:0:{}s:15:\"product-primary\";a:0:{}s:17:\"product-secondary\";a:0:{}s:17:\"portfolio-primary\";a:0:{}s:19:\"portfolio-secondary\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("107","cron","a:28:{i:1734930416;a:1:{s:23:\"delete_error_logs_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1734930422;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1734930433;a:1:{s:33:\"somdn_delete_download_files_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1734933023;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1734933484;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1734933585;a:1:{s:26:\"xtra-theme-ir_notify_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1734934855;a:1:{s:24:\"wpb_data_sync_loginpress\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734936998;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"9d178029547e4490347030b0ad8b5426\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:22299;}}}}i:1734945501;a:1:{s:30:\"puc_cron_check_updates-imagify\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734945851;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734946008;a:1:{s:36:\"puc_cron_check_updates-elementor-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734947632;a:1:{s:21:\"empty_all_trash_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734949800;a:1:{s:20:\"imagify_rating_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734961823;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734961839;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734962266;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734962284;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734989564;a:1:{s:39:\"rocket_database_optimization_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734990934;a:1:{s:28:\"zhaket_guard_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735002000;a:1:{s:18:\"imagify_sync_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735013744;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735013745;a:1:{s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735307425;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735393823;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735441200;a:1:{s:46:\"imagify_update_library_size_calculations_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735554600;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735763763;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_search","a:3:{i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("119","widget_tag_cloud","a:3:{i:1;a:9:{s:5:\"title\";s:8:\"وسوم\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:9:{s:5:\"title\";s:8:\"وسوم\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("124","theme_mods_twentytwentyfour","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1718977948;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","no"),
("125","recovery_keys","a:0:{}","off"),
("157","recently_activated","a:13:{s:33:\"classic-editor/classic-editor.php\";i:1734862168;s:61:\"download-now-for-woocommerce/som-woocommerce-download-now.php\";i:1734857153;s:27:\"woocommerce/woocommerce.php\";i:1734857132;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:1734857127;s:45:\"persian-woocommerce-sms/WoocommerceIR_SMS.php\";i:1734857122;s:70:\"the-plus-addons-for-elementor-page-builder/theplus_elementor_addon.php\";i:1734850698;s:51:\"theplus_elementor_addon/theplus_elementor_addon.php\";i:1734850687;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1734849407;s:62:\"all-in-one-wp-security-and-firewall-premium/aiowps-premium.php\";i:1734849374;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1734848701;s:25:\"loginpress/loginpress.php\";i:1734848427;s:31:\"zoneit-backup/zoneit-backup.php\";i:1734780951;s:20:\"uPanel/hd-upanel.php\";i:1734780347;}","off"),
("168","finished_updating_comment_type","1","yes"),
("176","xtra_generate_css_out","1","yes"),
("177","xtra_generate_css_out_version","4416","yes"),
("178","widget_codevz_working_hours","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("179","widget_codevz_stylish_list","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("180","widget_codevz_social_icons","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("181","widget_codevz_custom_menu_list","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("182","widget_codevz_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("183","widget_codevz_posts_grid","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("184","widget_codevz_about","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("185","widget_codevz_login","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("186","widget_codevz_exclusive_ads","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("187","widget_codevzfacebook","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("188","widget_codevzflickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("189","widget_codevzcustommenulist","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("190","widget_codevzcustommenulist2","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("191","widget_codevzpostslist","a:3:{i:1;a:25:{s:5:\"title\";s:18:\"المشاركات\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"4\";s:9:\"pagecount\";s:1:\"4\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:2;a:25:{s:5:\"title\";s:18:\"المشاركات\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"4\";s:9:\"pagecount\";s:1:\"4\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("192","widget_codevzsimpleads","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("193","widget_codevzsubscribe","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("194","widget_codevzpagecontent","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("195","widget_codevzportfolio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("196","widget_lc_taxonomy","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("197","widget_codevz_soundcloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("198","widget_codevz_unboxed","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("199","widget_xtra_newsletter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("204","current_theme","XTRA","yes"),
("205","theme_mods_xtra","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:49;s:6:\"footer\";i:48;}s:18:\"custom_css_post_id\";i:-1;}","yes"),
("206","theme_switched","","yes"),
("207","elementor_experiment-e_font_icon_svg","inactive","yes"),
("208","codevz_theme_options","a:308:{s:6:\"layout\";s:4:\"none\";s:7:\"primary\";s:7:\"primary\";s:9:\"secondary\";s:9:\"secondary\";s:10:\"responsive\";b:1;s:23:\"responsive_breakpoint_2\";s:5:\"960px\";s:23:\"responsive_breakpoint_3\";s:5:\"420px\";s:3:\"css\";s:95:\"body.home.blog .page_cover { display: none; } body.home.blog .page_content { margin-top: 40px }\";s:10:\"site_color\";s:7:\"#4f5cde\";s:12:\"_css_widgets\";s:76:\"background-color:rgba(79,92,222,0.06);margin-bottom:24px;border-radius:10px;\";s:21:\"_css_widgets_headline\";s:167:\"font-size:18px;color:#ffffff;background-color:#4f5cde;padding:15px 30px;margin:-30px -30px 30px;border-style:solid;border-bottom-width:0px;border-radius:10px 10px 0 0;\";s:13:\"_css_logo_css\";s:33:\"CDVZtext-transform:uppercase;CDVZ\";s:17:\"social_color_mode\";s:26:\"cz_social_colored_bg_hover\";s:33:\"_css_menu_a_hover_before_header_1\";s:40:\"_class_menu_fx:cz_menu_fx_left_to_right;\";s:24:\"menus_indicator_header_1\";s:16:\"fa fa-angle-down\";s:25:\"menus_indicator2_header_1\";s:17:\"fa fa-angle-right\";s:13:\"header_2_left\";a:2:{i:0;a:93:{s:7:\"element\";s:4:\"logo\";s:10:\"element_id\";s:13:\"header_2_left\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:5:\"140px\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_1\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:0:\"\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"29px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:4:\"35px\";s:4:\"left\";s:0:\"\";}}i:1;a:93:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:13:\"header_2_left\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:0:\"\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_2\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:4:\"40px\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"44px\";s:5:\"right\";s:4:\"40px\";s:6:\"bottom\";s:4:\"30px\";s:4:\"left\";s:4:\"40px\";}}}s:14:\"header_2_right\";a:2:{i:0;a:93:{s:7:\"element\";s:6:\"social\";s:10:\"element_id\";s:14:\"header_2_right\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:18:\"Type a keyword ...\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:42:\"background-color:#4f5cde;margin-left:-3px;\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:126:\"font-size:14px;color:#ffffff;background-color:#4f5cde;padding:3px;border-radius:50px;box-shadow:0px 5px 30px rgba(0,0,0,0.16);\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:14:\"color:#000000;\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:68:\"margin-top:15px;border-style:none;border-radius:5px;box-shadow:none;\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_1\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:0:\"\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"44px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}i:1;a:93:{s:7:\"element\";s:6:\"button\";s:10:\"element_id\";s:14:\"header_2_right\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:0:\"\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:17:\"آموزش نصب\";s:8:\"btn_link\";s:9:\"/install/\";s:6:\"sk_btn\";s:81:\"padding:6px 24px;border-radius:50px;box-shadow:0px 10px 30px rgba(79,92,222,0.5);\";s:12:\"sk_btn_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_2\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:4:\"40px\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"40px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:4:\"10px\";}}}s:23:\"_css_container_header_2\";s:99:\"background-color:transparent;background-image:linear-gradient(0deg,rgba(255,255,255,0.53),#ffffff);\";s:20:\"_css_menu_a_header_2\";s:90:\"font-size:14px;letter-spacing:0px;padding:5px 10px 6px;margin:0px 10px;border-radius:50px;\";s:26:\"_css_menu_a_hover_header_2\";s:14:\"color:#ffffff;\";s:33:\"_css_menu_a_hover_before_header_2\";s:98:\"_class_menu_fx:cz_menu_fx_zoom_in;border-radius:50px;box-shadow:0px 10px 30px rgba(79,92,222,0.5);\";s:24:\"menus_indicator_header_2\";s:16:\"fa fa-angle-down\";s:21:\"_css_menu_ul_header_2\";s:122:\"background-color:#4f5cde;width:260px;margin:6px 12px 1px 24px;border-radius:10px;box-shadow:0px 9px 20px rgba(0,0,0,0.13);\";s:23:\"_css_menu_ul_a_header_2\";s:29:\"font-size:14px;color:#cecece;\";s:29:\"_css_menu_ul_a_hover_header_2\";s:14:\"color:#ffffff;\";s:25:\"menus_indicator2_header_2\";s:17:\"fa fa-angle-right\";s:24:\"menus_indicator_header_3\";s:16:\"fa fa-angle-down\";s:25:\"menus_indicator2_header_3\";s:17:\"fa fa-angle-right\";s:12:\"smart_sticky\";b:1;s:23:\"_css_container_header_5\";s:71:\"background-color:#ffffff;box-shadow:0px 10px 30px rgba(79,92,222,0.15);\";s:24:\"menus_indicator_header_5\";s:16:\"fa fa-angle-down\";s:25:\"menus_indicator2_header_5\";s:17:\"fa fa-angle-right\";s:13:\"header_4_left\";a:1:{i:0;a:89:{s:7:\"element\";s:4:\"logo\";s:10:\"element_id\";s:13:\"header_4_left\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:5:\"120px\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:57:\"https://wantedrp.ir/wp-content/uploads/2024/06/header.png\";s:11:\"image_width\";s:5:\"100px\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_1\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:0:\"\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"28px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:4:\"22px\";s:4:\"left\";s:0:\"\";}}}s:14:\"header_4_right\";a:1:{i:0;a:89:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:14:\"header_4_right\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:0:\"\";s:9:\"menu_type\";s:20:\"offcanvas_menu_right\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:134:\"font-size:18px;color:#ffffff;background-color:#4f5cde;padding:3px;border-radius:50px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_1\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:0:\"\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:4:\"22px\";s:4:\"left\";s:0:\"\";}}}s:23:\"_css_container_header_4\";s:0:\"\";s:20:\"_css_menu_a_header_4\";s:152:\"font-size:16px;color:rgba(255,255,255,0.7);text-align:center;margin-right:30px;margin-bottom:10px;margin-left:30px;border-style:none;border-radius:50px;\";s:26:\"_css_menu_a_hover_header_4\";s:53:\"color:#ffffff;background-color:rgba(255,255,255,0.1);\";s:24:\"menus_indicator_header_4\";s:16:\"fa fa-angle-down\";s:23:\"_css_menu_ul_a_header_4\";s:14:\"color:#606060;\";s:29:\"_css_menu_ul_a_hover_header_4\";s:14:\"color:#3f51b5;\";s:25:\"menus_indicator2_header_4\";s:16:\"fa fa-angle-down\";s:10:\"page_cover\";s:5:\"title\";s:10:\"page_title\";s:1:\"6\";s:21:\"breadcrumbs_home_icon\";s:10:\"fa fa-home\";s:21:\"breadcrumbs_separator\";s:17:\"fa fa-angle-right\";s:15:\"_css_page_title\";s:36:\"padding-top:10px;padding-bottom:8px;\";s:21:\"_css_page_title_color\";s:66:\"font-size:24px;color:#000000;padding-top:10px;padding-bottom:10px;\";s:33:\"_css_page_title_breadcrumbs_color\";s:0:\"\";s:32:\"_css_breadcrumbs_inner_container\";s:68:\"padding-top:5px;padding-bottom:5px;margin-top:7px;margin-right:10px;\";s:11:\"_css_footer\";s:62:\"background-color:#4f5cde;padding-top:60px;padding-bottom:50px;\";s:18:\"_css_footer_widget\";s:42:\"color:#ffffff;padding:10px 10px 10px 10px;\";s:13:\"_css_footer_a\";s:44:\"font-size:13px;color:#ffffff;line-height: 2;\";s:19:\"_css_footer_a_hover\";s:14:\"color:#c6c6c6;\";s:15:\"footer_2_center\";s:0:\"\";s:23:\"_css_container_footer_2\";s:0:\"\";s:14:\"_css_backtotop\";s:93:\"color:#ffffff;background-color:#4f5cde;border-style:none;border-width:0px;border-radius:50px;\";s:25:\"_css_cf7_beside_backtotop\";s:119:\"color:#4f5cde;margin-right:3px;border-style:none;border-radius:50px 0 0 50px ;box-shadow:0px 0px 10px rgba(0,0,0,0.15);\";s:14:\"meta_data_post\";a:4:{i:0;s:5:\"image\";i:1;s:6:\"author\";i:2;s:4:\"date\";i:3;s:9:\"next_prev\";}s:12:\"related_post\";s:21:\"You May Also Like ...\";s:14:\"slug_portfolio\";s:8:\"projects\";s:15:\"title_portfolio\";s:8:\"Projects\";s:13:\"cat_portfolio\";s:12:\"projects/cat\";s:14:\"tags_portfolio\";s:13:\"projects/tags\";s:20:\"tags_title_portfolio\";s:4:\"Tags\";s:19:\"meta_data_portfolio\";a:3:{i:0;s:4:\"date\";i:1;s:4:\"cats\";i:2;s:4:\"tags\";}s:17:\"related_portfolio\";s:21:\"You May Also Like ...\";s:17:\"primary_portfolio\";s:7:\"primary\";s:19:\"secondary_portfolio\";s:9:\"secondary\";s:19:\"page_coverportfolio\";s:1:\"1\";s:19:\"page_titleportfolio\";s:1:\"1\";s:28:\"_css_footer_widget_headlines\";s:85:\"color:#ffffff;font-size:28px;font-weight:100;border-style:solid;border-width:0 0 1px;\";s:20:\"page_cover_portfolio\";s:1:\"1\";s:28:\"_css_woo_products_thumbnails\";s:28:\"border-radius:10px 10px 0 0;\";s:20:\"page_title_portfolio\";s:1:\"1\";s:18:\"page_cover_product\";s:1:\"1\";s:18:\"page_title_product\";s:1:\"1\";s:7:\"woo_col\";s:1:\"4\";s:23:\"_css_woo_products_title\";s:49:\"font-size:18px;margin-top:5px;margin-bottom:30px;\";s:23:\"_css_woo_products_stars\";s:13:\"display:none;\";s:29:\"_css_woo_products_add_to_cart\";s:91:\"font-size:14px;color:#ffffff;background-color:#4f5cde;margin-top:-22px;border-radius:100px;\";s:24:\"_css_woo_products_onsale\";s:89:\"font-size:10px;color:#ffffff;font-weight:400;background-color:#079700;top:10px;left:10px;\";s:23:\"_css_woo_products_price\";s:54:\"font-size:16px;color:#4f5cde;background-color:#ffffff;\";s:22:\"_css_woo_product_price\";s:45:\"font-size:36px;color:#4f5cde;font-weight:700;\";s:16:\"_css_woo_buttons\";s:39:\"color:#ffffff;background-color:#4f5cde;\";s:22:\"_css_woo_buttons_hover\";s:51:\"color:#4f5cde;background-color:rgba(79,92,222,0.1);\";s:24:\"posts_per_page_portfolio\";s:1:\"6\";s:25:\"cf7_beside_backtotop_icon\";s:16:\"fa fa-comments-o\";s:8:\"readmore\";s:19:\"ادامه مطلب\";s:13:\"readmore_icon\";s:11:\"fa fa-chain\";s:26:\"_css_tags_categories_hover\";s:84:\"color:#ffffff;background-color:#4f5cde;box-shadow:0px 10px 30px rgba(79,92,222,0.5);\";s:18:\"_css_pagination_li\";s:132:\"color:rgba(128,136,221,0.8);margin-top:40px;margin-right:3px;border-style:solid;border-color:rgba(79,92,222,0.2);border-radius:50px;\";s:21:\"_css_pagination_hover\";s:59:\"color:#ffffff;box-shadow:0px 10px 30px rgba(79,92,222,0.5);\";s:24:\"_css_menu_ul_ul_header_2\";s:34:\"margin-top:-15px;margin-left:62px;\";s:16:\"related_post_col\";s:2:\"s3\";s:16:\"related_post_ppp\";s:1:\"2\";s:13:\"_css_readmore\";s:260:\"color:rgba(255,255,255,0.8);padding-right:12px;padding-left:21px;margin-top:50px;border-style:solid;border-width:1px;border-color:#4f5cde;border-radius:50px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);float:left;RTLpadding-left:21px;padding-right:12px;RTL\";s:19:\"_css_readmore_hover\";s:94:\"color:#4f5cde;background-color:rgba(255,255,255,0.01);border-style:solid;border-color:#4f5cde;\";s:17:\"columns_portfolio\";s:1:\"3\";s:24:\"template_style_portfolio\";s:1:\"1\";s:21:\"related_portfolio_col\";s:2:\"s4\";s:21:\"related_portfolio_ppp\";s:1:\"3\";s:12:\"woo_template\";s:1:\"1\";s:15:\"woo_related_col\";s:1:\"4\";s:35:\"_css_woo_products_add_to_cart_hover\";s:88:\"color:#4f5cde;background-color:#ffffff;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:16:\"_css_post_avatar\";s:134:\"padding:2px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;box-shadow:none;display:none;CDVZwidth:42pxCDVZ\";s:16:\"_css_post_author\";s:58:\"font-size:14px;color:#000370;font-weight:600;display:none;\";s:14:\"_css_post_date\";s:121:\"font-size:12px;color:#4f5cde;background-color:rgba(79,92,222,0.15);padding:6px 14px;margin-left:-13px;border-radius:50px;\";s:15:\"_css_post_title\";s:83:\"font-size:28px;line-height:34px;margin-top:30px;margin-right:30px;margin-left:30px;\";s:33:\"_css_menu_ul_indicator_a_header_2\";s:49:\"_class_indicator:fa fa-angle-right;color:#ffffff;\";s:30:\"_css_menu_indicator_a_header_2\";s:34:\"_class_indicator:fa fa-angle-down;\";s:16:\"_css_sticky_post\";s:133:\"background-color:rgba(79,92,222,0.04);margin-bottom:40px;border-style:solid;border-width:2px;border-color:#000370;border-radius:10px;\";s:17:\"_css_overall_post\";s:93:\"background-color:rgba(79,92,222,0.06);margin-bottom:0px;border-style:none;border-radius:10px;\";s:22:\"_css_post_meta_overall\";s:106:\"margin-right:30px;margin-left:30px;border-width:0px 0px 0px 6px;border-color:#4f5cde;display:inline-block;\";s:28:\"_css_related_posts_sec_title\";s:167:\"font-size:18px;color:#ffffff;background-color:#4f5cde;padding:15px 30px;margin:-30px -30px 30px;border-style:solid;border-bottom-width:0px;border-radius:10px 10px 0 0;\";s:26:\"_css_single_comments_title\";s:167:\"font-size:18px;color:#ffffff;background-color:#4f5cde;padding:15px 30px;margin:-30px -30px 30px;border-style:solid;border-bottom-width:0px;border-radius:10px 10px 0 0;\";s:20:\"_css_next_prev_icons\";s:160:\"color:#ffffff;background-color:#4f5cde;border-style:solid;border-width:1px;border-color:#4f5cde;border-radius:50px;box-shadow:0px 10px 30px rgba(79,92,222,0.5);\";s:26:\"_css_next_prev_icons_hover\";s:95:\"color:#4f5cde;background-color:#ffffff;border-style:solid;border-color:#4f5cde;box-shadow:none;\";s:21:\"_css_next_prev_titles\";s:33:\"margin-right:8px;margin-left:8px;\";s:18:\"_css_all_headlines\";s:0:\"\";s:12:\"breakpoint_2\";s:5:\"768px\";s:12:\"breakpoint_3\";s:5:\"480px\";s:12:\"post_excerpt\";s:2:\"17\";s:9:\"prev_post\";s:17:\"مطلب قبلی\";s:9:\"next_post\";s:17:\"مطلب بعدی\";s:18:\"related_posts_post\";s:24:\"‫مطالب مرتبط\";s:8:\"comments\";s:10:\"نظرات\";s:14:\"cols_portfolio\";s:2:\"s4\";s:23:\"related_posts_portfolio\";s:17:\"Related Posts ...\";s:16:\"_css_inner_title\";s:15:\"font-size:32px;\";s:17:\"_css_single_title\";s:15:\"font-size:32px;\";s:16:\"_css_single_mbot\";s:14:\"color:#727272;\";s:18:\"_css_single_mbot_i\";s:14:\"color:#000370;\";s:18:\"primary_buddypress\";s:7:\"primary\";s:20:\"secondary_buddypress\";s:9:\"secondary\";s:21:\"page_cover_buddypress\";s:1:\"1\";s:21:\"page_title_buddypress\";s:1:\"1\";s:8:\"lazyload\";b:1;s:17:\"remove_query_args\";b:1;s:18:\"vc_disable_modules\";a:12:{i:0;s:12:\"vc_wp_search\";i:1;s:10:\"vc_wp_meta\";i:2;s:20:\"vc_wp_recentcomments\";i:3;s:14:\"vc_wp_calendar\";i:4;s:11:\"vc_wp_pages\";i:5;s:14:\"vc_wp_tagcloud\";i:6;s:16:\"vc_wp_custommenu\";i:7;s:10:\"vc_wp_text\";i:8;s:11:\"vc_wp_posts\";i:9;s:16:\"vc_wp_categories\";i:10;s:14:\"vc_wp_archives\";i:11;s:9:\"vc_wp_rss\";}s:9:\"backtotop\";s:14:\"fa fa-angle-up\";s:4:\"logo\";s:56:\"http://localhost/wp-content/uploads/2024/06/WantedRp.png\";s:21:\"_css_header_container\";s:109:\"background-color:transparent;background-image:linear-gradient(180deg,rgba(0,0,0,0.1),rgba(255,255,255,0.01));\";s:14:\"_css_body_typo\";s:0:\"\";s:18:\"_css_header_2_left\";s:31:\"_class_shape:cz_row_shape_none;\";s:17:\"_css_row_header_2\";s:0:\"\";s:9:\"_css_body\";s:0:\"\";s:6:\"social\";a:4:{i:0;a:3:{s:5:\"title\";s:8:\"Telegram\";s:4:\"icon\";s:15:\"fab fa-telegram\";s:4:\"link\";s:1:\"#\";}i:1;a:3:{s:5:\"title\";s:9:\"Instagram\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:4:\"link\";s:1:\"#\";}i:2;a:3:{s:5:\"title\";s:6:\"Aparat\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}i:3;a:3:{s:5:\"title\";s:7:\"YouTube\";s:4:\"icon\";s:14:\"fab fa-youtube\";s:4:\"link\";s:0:\"\";}}s:15:\"header_2_center\";s:0:\"\";s:15:\"social_hover_fx\";s:14:\"cz_social_fx_6\";s:13:\"_css_social_a\";s:135:\"color:#4f5cde;margin-right:2px;margin-left:2px;border-style:solid;border-width:1px;border-color:rgba(79,92,222,0.2);border-radius:50px;\";s:14:\"social_tooltip\";s:24:\"cz_tooltip cz_tooltip_up\";s:19:\"_css_social_a_hover\";s:84:\"color:#ffffff;background-color:#282828;box-shadow:0px 10px 30px rgba(79,92,222,0.5);\";s:19:\"_css_social_tooltip\";s:110:\"font-size:11px;color:#ffffff;font-weight:500;background-color:#4f5cde;padding:8px 14px 9px;border-radius:50px;\";s:13:\"footer_2_left\";a:1:{i:0;a:93:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:13:\"footer_2_left\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:0:\"\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:130:\"© [codevz_year] هرگونه کپی برداری از مطالب و محصولات این فروشگاه حرام می باشد .\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:29:\"font-size:14px;color:#aaaaaa;\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_2\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:4:\"40px\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:0:\"\";}}}s:14:\"footer_2_right\";a:1:{i:0;a:93:{s:7:\"element\";s:6:\"social\";s:10:\"element_id\";s:14:\"footer_2_right\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:0:\"\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:56:\"https://wantedrp.ir/wp-content/uploads/2018/04/cards.jpg\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_2\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:4:\"40px\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:4:\"30px\";s:4:\"left\";s:0:\"\";}}}s:17:\"_css_row_footer_2\";s:61:\"border-style:solid;border-top-width:1px;border-color:#e5e5e5;\";s:13:\"footer_1_left\";a:1:{i:0;a:94:{s:7:\"element\";s:5:\"image\";s:10:\"element_id\";s:13:\"footer_1_left\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:5:\"100px\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:0:\"\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:54:\"http://localhost/wp-content/uploads/2024/06/enamad.png\";s:11:\"image_width\";s:5:\"100px\";s:10:\"image_link\";s:0:\"\";s:13:\"image_new_tab\";s:1:\"1\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_2\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:4:\"40px\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:0:\"\";}}}s:14:\"footer_1_right\";a:1:{i:0;a:93:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:14:\"footer_1_right\";s:15:\"header_elements\";s:0:\"\";s:21:\"header_elements_width\";s:0:\"\";s:6:\"custom\";s:0:\"\";s:10:\"logo_width\";s:0:\"\";s:17:\"logo_width_sticky\";s:0:\"\";s:11:\"logo_slogan\";s:0:\"\";s:14:\"sk_logo_slogan\";s:0:\"\";s:13:\"menu_location\";s:6:\"footer\";s:9:\"menu_type\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"sk_menu_icon\";s:0:\"\";s:18:\"sk_menu_icon_hover\";s:0:\"\";s:13:\"sk_menu_title\";s:0:\"\";s:19:\"sk_menu_title_hover\";s:0:\"\";s:11:\"social_type\";s:0:\"\";s:11:\"social_icon\";s:0:\"\";s:14:\"sk_social_icon\";s:0:\"\";s:20:\"sk_social_icon_hover\";s:0:\"\";s:19:\"sk_social_container\";s:0:\"\";s:5:\"image\";s:0:\"\";s:11:\"image_width\";s:0:\"\";s:10:\"image_link\";s:0:\"\";s:8:\"sk_image\";s:0:\"\";s:7:\"it_icon\";s:0:\"\";s:7:\"it_text\";s:0:\"\";s:9:\"it_text_2\";s:0:\"\";s:7:\"it_link\";s:0:\"\";s:10:\"sk_it_wrap\";s:0:\"\";s:16:\"sk_it_wrap_hover\";s:0:\"\";s:5:\"sk_it\";s:0:\"\";s:11:\"sk_it_hover\";s:0:\"\";s:7:\"sk_it_2\";s:0:\"\";s:13:\"sk_it_2_hover\";s:0:\"\";s:10:\"sk_it_icon\";s:0:\"\";s:16:\"sk_it_icon_hover\";s:0:\"\";s:11:\"search_type\";s:4:\"form\";s:11:\"search_icon\";s:0:\"\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_trending_title\";s:0:\"\";s:21:\"search_trending_items\";s:0:\"\";s:17:\"search_form_width\";s:0:\"\";s:15:\"sk_search_title\";s:0:\"\";s:18:\"sk_search_trending\";s:0:\"\";s:24:\"sk_search_trending_hover\";s:0:\"\";s:13:\"sk_search_con\";s:0:\"\";s:15:\"sk_search_input\";s:0:\"\";s:14:\"sk_search_icon\";s:0:\"\";s:20:\"sk_search_icon_hover\";s:0:\"\";s:17:\"sk_search_icon_in\";s:0:\"\";s:23:\"sk_search_cat_selection\";s:0:\"\";s:18:\"sk_search_cat_list\";s:0:\"\";s:12:\"search_count\";s:0:\"\";s:16:\"search_post_icon\";s:0:\"\";s:14:\"sk_search_ajax\";s:0:\"\";s:19:\"sk_search_post_icon\";s:0:\"\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:12:\"sk_offcanvas\";s:0:\"\";s:14:\"offcanvas_icon\";s:0:\"\";s:17:\"sk_offcanvas_icon\";s:0:\"\";s:23:\"sk_offcanvas_icon_hover\";s:0:\"\";s:9:\"btn_title\";s:0:\"\";s:8:\"btn_link\";s:0:\"\";s:6:\"sk_btn\";s:0:\"\";s:12:\"sk_btn_hover\";s:0:\"\";s:11:\"hf_elm_page\";s:0:\"\";s:9:\"sk_hf_elm\";s:0:\"\";s:11:\"hf_elm_icon\";s:0:\"\";s:14:\"sk_hf_elm_icon\";s:0:\"\";s:20:\"sk_hf_elm_icon_hover\";s:0:\"\";s:12:\"btn_icon_pos\";s:0:\"\";s:11:\"shop_plugin\";s:3:\"woo\";s:13:\"shopcart_icon\";s:0:\"\";s:14:\"shopcart_title\";s:0:\"\";s:16:\"shopcart_tooltip\";s:0:\"\";s:17:\"sk_shop_container\";s:0:\"\";s:12:\"sk_shop_icon\";s:0:\"\";s:13:\"sk_shop_count\";s:0:\"\";s:15:\"sk_shop_content\";s:0:\"\";s:9:\"line_type\";s:13:\"header_line_2\";s:7:\"sk_line\";s:0:\"\";s:10:\"wpml_title\";s:15:\"translated_name\";s:18:\"wpml_current_color\";s:0:\"\";s:15:\"wpml_background\";s:0:\"\";s:10:\"wpml_color\";s:0:\"\";s:11:\"avatar_size\";s:4:\"40px\";s:9:\"sk_avatar\";s:0:\"\";s:11:\"avatar_link\";s:0:\"\";s:14:\"elm_visibility\";s:0:\"\";s:13:\"elm_on_sticky\";s:0:\"\";s:6:\"margin\";a:4:{s:3:\"top\";s:5:\"100px\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}}s:20:\"_css_menu_a_footer_1\";s:49:\"color:#969696;margin-right:15px;margin-left:15px;\";s:26:\"_css_menu_a_hover_footer_1\";s:14:\"color:#4f5cde;\";s:33:\"_css_menu_a_hover_before_footer_1\";s:13:\"display:none;\";s:20:\"_css_backtotop_hover\";s:73:\"background-color:#222222;box-shadow:0px 5px 30px 0px rgba(79,92,222,0.5);\";s:12:\"_css_buttons\";s:142:\"font-weight:700;border-style:solid;border-width:1px;border-color:#4f5cde;border-radius:100px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:28:\"_css_menu_container_header_4\";s:62:\"background-color:#4f5cde;padding-top:30px;padding-bottom:30px;\";s:21:\"_css_menu_li_header_4\";s:0:\"\";s:28:\"_css_menu_container_footer_1\";s:56:\"margin-right:-15px;margin-bottom:15px;margin-left:-15px;\";s:21:\"_css_menu_li_footer_1\";s:51:\"text-align:justify;display:inline-block;float:none;\";s:17:\"_css_all_img_tags\";s:19:\"border-radius:10px;\";s:14:\"template_style\";s:2:\"12\";s:15:\"_css_post_image\";s:46:\"margin-bottom:0px;border-radius:10px 10px 0 0;\";s:18:\"_css_buttons_hover\";s:79:\"color:#4f5cde;background-color:#ffffff;border-style:solid;border-color:#ffffff;\";s:19:\"_css_input_textarea\";s:70:\"color:#212121;padding-right:15px;padding-left:15px;border-radius:20px;\";s:20:\"_css_sidebar_primary\";s:0:\"\";s:11:\"_css_select\";s:56:\"padding-right:20px;padding-left:20px;border-radius:20px;\";s:20:\"_css_select_dropdown\";s:0:\"\";s:15:\"_css_readmore_i\";s:14:\"color:#ffffff;\";s:21:\"_css_readmore_hover_i\";s:14:\"color:#4f5cde;\";s:17:\"_css_post_excerpt\";s:35:\"margin-right:30px;margin-left:30px;\";s:15:\"_css_single_con\";s:0:\"\";s:20:\"_css_tags_categories\";s:36:\"padding:2px 15px;border-radius:50px;\";s:23:\"_css_single_post_author\";s:0:\"\";s:23:\"_css_single_post_avatar\";s:0:\"\";s:18:\"_css_related_posts\";s:0:\"\";s:24:\"_css_related_posts_title\";s:0:\"\";s:23:\"_css_related_posts_meta\";s:0:\"\";s:22:\"_css_related_posts_img\";s:38:\"margin-bottom:30px;border-radius:10px;\";s:29:\"_css_related_posts_meta_links\";s:0:\"\";s:23:\"_css_single_comments_li\";s:62:\"background-color:#ffffff;border-style:none;border-radius:10px;\";s:14:\"posts_per_page\";s:1:\"4\";s:6:\"sticky\";b:1;s:25:\"_css_page_title_inner_row\";s:135:\"padding-top:10px;padding-bottom:10px;border-style:solid;border-top-width:1px;border-bottom-width:1px;border-color:rgba(79,92,222,0.15);\";s:13:\"sticky_header\";s:1:\"2\";s:5:\"boxed\";b:0;s:9:\"fonts_out\";a:1:{i:0;s:22:\"font-family:Open Sans;\";}s:20:\"_css_post_hover_icon\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:21:\"_css_readmore_i_hover\";s:14:\"color:#4f5cde;\";s:15:\"custom_sidebars\";a:1:{i:0;b:0;}s:14:\"site_color_sec\";s:0:\"\";s:13:\"seo_meta_tags\";b:1;s:8:\"seo_desc\";s:153:\"یکی از برترین سرور گیم های ام تی ای که میتوانید دنیای خود را در آن بسازید و لذت ببرید .\";s:12:\"seo_keywords\";s:207:\"سرور ام تی ای , سرور آر پی , سرور آر پی جی , جی تی ای آنلاین , جی تی ای سن آندرس , جی تی ای سن آندریاس , ام تی ای سن آندریاس\";s:11:\"layout_post\";s:2:\"ws\";s:25:\"_css_tags_categories_icon\";s:64:\"text-align:center;width:30px;padding-right:0px;padding-left:0px;\";s:9:\"post_type\";s:0:\"\";s:5:\"share\";a:4:{i:0;s:8:\"whatsapp\";i:1;s:8:\"telegram\";i:2;s:8:\"envelope\";i:3;s:4:\"copy\";}s:13:\"share_tooltip\";b:1;s:11:\"share_color\";s:26:\"cz_social_colored_bg_hover\";s:10:\"_css_share\";s:144:\"background-color:rgba(79,92,222,0.06);padding-top:60px;padding-bottom:20px;margin-bottom:24px;border-style:none;border-radius:10px;display:flex;\";s:12:\"_css_share_a\";s:19:\"border-radius:99px;\";s:18:\"_css_share_tooltip\";s:75:\"color:#ffffff;background-color:#4f5cde;padding:8px 16px;border-radius:99px;\";s:22:\"_css_related_posts_con\";s:98:\"background-color:rgba(79,92,222,0.06);padding:30px 30px 0px;margin-bottom:24px;border-radius:10px;\";s:24:\"_css_single_comments_con\";s:99:\"background-color:rgba(79,92,222,0.06);padding:30px 30px 10px;margin-bottom:24px;border-radius:10px;\";s:18:\"_css_share_a_hover\";s:49:\"box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:39:\"_css_breadcrumbs_inner_container_mobile\";s:13:\"display:none;\";s:28:\"_css_woo_product_related_con\";s:98:\"background-color:rgba(79,92,222,0.06);padding:30px 30px 0px;margin-bottom:24px;border-radius:10px;\";s:30:\"_css_woo_product_related_title\";s:167:\"font-size:18px;color:#ffffff;background-color:#4f5cde;padding:15px 30px;margin:-30px -30px 30px;border-style:solid;border-bottom-width:0px;border-radius:10px 10px 0 0;\";s:34:\"_css_woo_products_quick_view_popup\";s:19:\"border-radius:10px;\";s:18:\"woo_items_per_page\";s:1:\"8\";s:16:\"woo_hover_effect\";s:7:\"blurred\";s:12:\"woo_wishlist\";b:0;s:14:\"woo_quick_view\";b:1;s:23:\"_css_woo_products_icons\";s:67:\"padding:5px;margin-right:12px;margin-left:12px;border-radius:100px;\";s:26:\"_css_woo_products_wishlist\";s:20:\"border-radius:100px;\";s:32:\"_css_woo_products_wishlist_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:28:\"_css_woo_products_quick_view\";s:20:\"border-radius:100px;\";s:34:\"_css_woo_products_quick_view_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:25:\"_css_woo_products_overall\";s:88:\"border-style:solid;border-width:3px;border-color:rgba(79,92,222,0.1);border-radius:12px;\";s:31:\"_css_woo_products_overall_hover\";s:40:\"border-style:solid;border-color:#4f5cde;\";s:29:\"_css_woo_products_title_hover\";s:0:\"\";s:25:\"_css_woo_product_wishlist\";s:69:\"border-radius:100px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:31:\"_css_woo_product_wishlist_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:20:\"_css_woo_product_qty\";s:49:\"width:140px;margin-right:-40px;margin-left:-40px;\";s:25:\"_css_woo_product_qty_down\";s:87:\"padding:8px;margin-left:5px;border-radius:100px;RTLmargin-left:0px;margin-right:5px;RTL\";s:31:\"_css_woo_product_qty_down_hover\";s:88:\"color:#ffffff;background-color:#4f5cde;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:23:\"_css_woo_product_qty_up\";s:88:\"padding:8px;margin-right:5px;border-radius:100px;RTLmargin-right:0px;margin-left:5px;RTL\";s:29:\"_css_woo_product_qty_up_hover\";s:88:\"color:#ffffff;background-color:#4f5cde;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:15:\"share_box_title\";s:39:\"اشتراک گذاری این صفحه\";s:16:\"_css_share_title\";s:279:\"font-size:16px;color:#ffffff;text-align:right;font-weight:700;background-color:#4f5cde;width:100%;padding:6px 30px;border-style:solid;border-width:0px 0px 1px;border-color:rgba(77,97,255,0.31);border-radius:10px 10px 0 0;position:absolute;top:0px;right:0px;box-sizing:border-box;\";s:21:\"_css_woo_product_tabs\";s:84:\"background-color:rgba(79,92,222,0.06);border-style:none;border-radius:10px 10px 0 0;\";s:27:\"_css_woo_product_active_tab\";s:39:\"color:#ffffff;background-color:#4f5cde;\";s:28:\"_css_woo_product_tab_content\";s:84:\"background-color:rgba(79,92,222,0.06);border-style:none;border-radius:0 0 10px 10px;\";s:22:\"_css_woo_product_title\";s:32:\"font-size:20px;padding-top:10px;\";s:18:\"mobile_menu_social\";b:1;s:16:\"mobile_menu_text\";s:35:\"© حقوق النشر[codevz_year]\";s:12:\"_css_mm_text\";s:51:\"color:#d6d6d6;padding-top:10px;padding-bottom:20px;\";s:14:\"_css_mms_icons\";s:133:\"font-size:18px;color:#ffffff;background-color:rgba(255,255,255,0.1);padding:5px;margin-right:4px;margin-left:4px;border-radius:100px;\";s:20:\"_css_mms_icons_hover\";s:39:\"color:#ffffff;background-color:#000000;\";s:23:\"mobile_fixed_navigation\";b:0;s:29:\"mobile_fixed_navigation_items\";s:0:\"\";s:29:\"mobile_fixed_navigation_title\";s:34:\"xtra-fixed-mobile-nav-title-column\";s:8:\"_css_mfn\";s:104:\"background-color:#4f5cde;border-radius:10px 10px 0 0;box-shadow:0px -10px 30px 0px rgba(79,92,222,0.06);\";s:10:\"_css_mfn_i\";s:90:\"background-color:rgba(255,255,255,0.1);padding:10px;margin-bottom:5px;border-radius:100px;\";s:16:\"_css_mfn_i_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:24:\"_css_overall_post_mobile\";s:19:\"margin-bottom:30px;\";s:8:\"woo_cart\";s:15:\"سبد خرید\";s:12:\"woo_checkout\";s:19:\"تسویه حساب\";s:21:\"woo_continue_shopping\";s:19:\"ادامه خرید\";s:15:\"woo_no_products\";s:72:\"هنوز محصولی برای خرید انتخاب نکرده اید .\";s:23:\"_css_woo_product_onsale\";s:21:\"right:10px;left:auto;\";s:7:\"404_msg\";s:151:\"عامو حالت خوبه ؟ ردیفی ؟ روالی عامو ؟ انگاری گم شدی بیو دستتو بگیرم ببرمت صفحه اصلی .\";s:7:\"404_btn\";s:17:\"صفحه اصلی\";s:9:\"not_found\";s:15:\"پیدا نشد\";s:10:\"no_comment\";s:40:\"هنوز نظری ثبت نشده است\";s:7:\"comment\";s:12:\"دیدگاه\";s:11:\"cm_disabled\";s:63:\"متاسفانه امکان نظر دهی وجود ندارد .\";s:11:\"woo_compare\";b:0;s:16:\"woo_ppp_dropdown\";b:1;s:18:\"woo_sold_out_badge\";b:1;s:22:\"woo_sold_out_grayscale\";b:1;s:19:\"woo_show_zero_count\";b:1;s:25:\"_css_woo_products_compare\";s:20:\"border-radius:100px;\";s:31:\"_css_woo_products_compare_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:24:\"_css_woo_product_compare\";s:69:\"border-radius:100px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);\";s:30:\"_css_woo_product_compare_hover\";s:39:\"color:#4f5cde;background-color:#ffffff;\";s:13:\"woo_new_label\";b:0;s:18:\"woo_new_label_days\";s:1:\"7\";s:30:\"woo_added_to_cart_notification\";b:1;s:30:\"woo_product_sticky_add_to_cart\";b:0;s:21:\"woo_product_brand_tab\";b:0;s:26:\"woo_product_size_guide_tab\";b:0;s:34:\"woo_product_size_guide_tab_content\";s:555:\"<table> <thead> <tr> <th>مقاس</th> <th>أمريكا</th> <th>أوروبا</th> <th>الإمارات</th> </tr> </thead> <tbody> <tr> <th>XS</th> <td>28-30</td> <td>27-29</td> <td>34-36</td> </tr> <tr> <th>S</th> <td>30-32</td> <td>29-31</td> <td>36-38</td> </tr> <tr> <th>M</th> <td>32-33</td> <td>31-33</td> <td>38-40</td> </tr> <tr> <th>L</th> <td>33-34</td> <td>33-36</td> <td>40-44</td> </tr> <tr> <th>XL</th> <td>34-38</td> <td>36-40</td> <td>44-48</td> </tr> <tr> <th>XXL</th> <td>38-48</td> <td>40-44</td> <td>48-50</td> </tr> </tbody> </table>\";s:32:\"woo_product_shipping_returns_tab\";b:0;s:28:\"woo_recently_viewed_products\";s:1:\"0\";s:15:\"woo_cart_footer\";s:74:\"سفارش شما بعد از 1 الی 24 ساعت انجام می شود.\";s:32:\"woo_product_size_guide_tab_title\";s:25:\"دليل المقاسات\";s:38:\"woo_product_shipping_returns_tab_title\";s:0:\"\";s:40:\"woo_product_shipping_returns_tab_content\";s:0:\"\";s:22:\"woo_after_product_meta\";s:341:\"<i class=\"fa fa-business-time\"></i>تحویل بین 30 دقیقه الی 72 ساعت می باشد<br/>\n<i class=\"fa fa-scale-balanced\"></i>حتما قبل از خرید قوانین را مطالعه فرمایید <br/>\n<i class=\"fa fa-file-export\"></i>قبل از خرید با ادمین های مربوطه در ارتباط باشید\";s:30:\"woo_cart_page_related_products\";b:1;s:23:\"woo_cart_checkout_steps\";s:10:\"horizontal\";s:7:\"css_out\";s:21183:\"\n\n/* Theme color */a:hover, .sf-menu > .cz.current_menu > a, .sf-menu > .cz .cz.current_menu > a,.sf-menu > .current-menu-parent > a,.comment-text .star-rating span {color: #4f5cde} \nform button, .button, #edd-purchase-button, .edd-submit, .edd-submit.button.blue, .edd-submit.button.blue:hover, .edd-submit.button.blue:focus, [type=submit].edd-submit, .sf-menu > .cz > a:before,.sf-menu > .cz > a:before,\n.post-password-form input[type=\"submit\"], .wpcf7-submit, .submit_user, \n#commentform #submit, .commentlist li.bypostauthor > .comment-body:after,.commentlist li.comment-author-admin > .comment-body:after, \n .pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, \n.pagination .prev:hover, input[type=submit], .sticky:before, .commentlist li.comment-author-admin .fn,\ninput[type=submit],input[type=button],.cz_header_button,.cz_default_portfolio a,\n.cz_readmore, .more-link, a.cz_btn, .cz_highlight_1:after, div.cz_btn ,.woocommerce input.button.alt.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce .woocommerce-error .button,.woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button, .woocommerce-page .woocommerce-error .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-message .button,#add_payment_method table.cart input, .woocommerce-cart table.cart input:not(.input-text), .woocommerce-checkout table.cart input,.woocommerce input.button:disabled, .woocommerce input.button:disabled[disabled],#add_payment_method table.cart input, #add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .widget_product_search #searchsubmit,.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce div.product form.cart .button, .xtra-product-icons,.woocommerce button.button.alt {background-color: #4f5cde}\n.cs_load_more_doing, div.wpcf7 .wpcf7-form .ajax-loader {border-right-color: #4f5cde}\ninput:focus,textarea:focus,select:focus {border-color: #4f5cde !important}\n::selection {background-color: #4f5cde;color: #fff}\n::-moz-selection {background-color: #4f5cde;color: #fff}\n\n/* Custom */body.home.blog .page_cover { display: none; } body.home.blog .page_content { margin-top: 40px }\n\n/* Dynamic  */.widget{background-color:rgba(79,92,222,0.06);margin-bottom:24px;border-radius:10px}.widget > .codevz-widget-title, .sidebar_inner .widget_block > div > div > h2{font-size:18px;color:#ffffff;background-color:#4f5cde;padding:15px 30px;margin:-30px -30px 30px;border-style:solid;border-bottom-width:0px;border-radius:10px 10px 0 0}.logo > a, .logo > h1, .logo h2{text-transform:uppercase}.header_2{background-color:transparent;background-image:linear-gradient(0deg,rgba(255,255,255,0.53),#ffffff)}#menu_header_2 > .cz > a{font-size:14px;letter-spacing:0px;padding:5px 10px 6px;margin:0px 10px;border-radius:50px}#menu_header_2 > .cz > a:hover,#menu_header_2 > .cz:hover > a,#menu_header_2 > .cz.current_menu > a,#menu_header_2 > .current-menu-parent > a{color:#ffffff}#menu_header_2 > .cz > a:before{border-radius:50px;box-shadow:0px 10px 30px rgba(79,92,222,0.5)}#menu_header_2 .cz .sub-menu:not(.cz_megamenu_inner_ul),#menu_header_2 .cz_megamenu_inner_ul .cz_megamenu_inner_ul{background-color:#4f5cde;width:260px;margin:6px 12px 1px 24px;border-radius:10px;box-shadow:0px 9px 20px rgba(0,0,0,0.13)}#menu_header_2 .cz .cz a{font-size:14px;color:#cecece}#menu_header_2 .cz .cz a:hover,#menu_header_2 .cz .cz:hover > a,#menu_header_2 .cz .cz.current_menu > a,#menu_header_2 .cz .current_menu > .current_menu{color:#ffffff}.onSticky{background-color:#ffffff !important;box-shadow:0px 10px 30px rgba(79,92,222,0.15) !important}#menu_header_4 > .cz > a{font-size:16px;color:rgba(255,255,255,0.7);text-align:center;margin-right:30px;margin-bottom:10px;margin-left:30px;border-style:none;border-radius:50px}#menu_header_4 > .cz > a:hover,#menu_header_4 > .cz:hover > a,#menu_header_4 > .cz.current_menu > a,#menu_header_4 > .current-menu-parent > a{color:#ffffff;background-color:rgba(255,255,255,0.1)}#menu_header_4 .cz .cz a{color:#606060}#menu_header_4 .cz .cz a:hover,#menu_header_4 .cz .cz:hover > a,#menu_header_4 .cz .cz.current_menu > a,#menu_header_4 .cz .current_menu > .current_menu{color:#3f51b5}.page_title,.header_onthe_cover .page_title{padding-top:10px;padding-bottom:8px}.page_title .section_title{font-size:24px;color:#000000;padding-top:10px;padding-bottom:10px}.breadcrumbs{padding-top:5px;padding-bottom:5px;margin-top:7px;margin-right:10px}.cz_middle_footer{background-color:#4f5cde;padding-top:60px;padding-bottom:50px}.footer_widget{color:#ffffff;padding:10px 10px 10px 10px}.cz_middle_footer a{font-size:13px;color:#ffffff;line-height: 2}.cz_middle_footer a:hover{color:#c6c6c6}i.backtotop{color:#ffffff;background-color:#4f5cde;border-style:none;border-width:0px;border-radius:50px}i.fixed_contact{color:#4f5cde;margin-right:3px;border-style:none;border-radius:50px 0 0 50px ;box-shadow:0px 0px 10px rgba(0,0,0,0.15)}.footer_widget > .codevz-widget-title, footer .widget_block > div > div > h2{color:#ffffff;font-size:28px;font-weight:100;border-style:solid;border-width:0 0 1px}.woocommerce ul.products li.product a img{border-radius:10px 10px 0 0}.woocommerce ul.products li.product .woocommerce-loop-category__title, .woocommerce ul.products li.product .woocommerce-loop-product__title, .woocommerce ul.products li.product h3,.woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-category__title, .woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-product__title, .woocommerce.woo-template-2 ul.products li.product h3{font-size:18px;margin-top:5px;margin-bottom:30px}.woocommerce ul.products li.product .star-rating{display:none}.woocommerce ul.products li.product .button.add_to_cart_button, .woocommerce ul.products li.product .button[class*=\"product_type_\"]{font-size:14px;color:#ffffff;background-color:#4f5cde;margin-top:-22px;border-radius:100px}.woocommerce span.onsale, .woocommerce ul.products li.product .onsale,.woocommerce.single span.onsale, .woocommerce.single ul.products li.product .onsale{font-size:10px;color:#ffffff;font-weight:400;background-color:#079700;top:10px;left:10px}.woocommerce ul.products li.product .price{font-size:16px;color:#4f5cde;background-color:#ffffff}.woocommerce div.product .summary > p.price, .woocommerce div.product .summary > span.price{font-size:36px;color:#4f5cde;font-weight:700}.tagcloud a:hover, .widget .tagcloud a:hover, .cz_post_cat a:hover, .cz_post_views a:hover{color:#ffffff;background-color:#4f5cde;box-shadow:0px 10px 30px rgba(79,92,222,0.5)}.pagination a, .pagination > b, .pagination span, .page-numbers a, .page-numbers span, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span{color:rgba(128,136,221,0.8);margin-top:40px;margin-right:3px;border-style:solid;border-color:rgba(79,92,222,0.2);border-radius:50px}#menu_header_2 .sub-menu .sub-menu:not(.cz_megamenu_inner_ul){margin-top:-15px;margin-left:62px}.cz-cpt-post .cz_readmore, .cz-cpt-post .more-link{color:rgba(255,255,255,0.8);padding-right:12px;padding-left:21px;margin-top:50px;border-style:solid;border-width:1px;border-color:#4f5cde;border-radius:50px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5);float:left}.rtl.cz-cpt-post .cz_readmore,.rtl.cz-cpt-post .more-link{padding-left:21px;padding-right:12px}.cz-cpt-post .cz_readmore:hover, .cz-cpt-post .more-link:hover{color:#4f5cde;background-color:rgba(255,255,255,0.01);border-style:solid;border-color:#4f5cde}.woocommerce ul.products li.product .button.add_to_cart_button:hover, .woocommerce ul.products li.product .button[class*=\"product_type_\"]:hover{color:#4f5cde;background-color:#ffffff;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}.cz-cpt-post .cz_default_loop .cz_post_author_avatar img{padding:2px;border-style:solid;border-width:1px;border-color:#cccccc;border-radius:5px;box-shadow:none;display:none;width:42px}.cz-cpt-post .cz_default_loop .cz_post_author_name{font-size:14px;color:#000370;font-weight:600;display:none}.cz-cpt-post .cz_default_loop .cz_post_date{font-size:12px;color:#4f5cde;background-color:rgba(79,92,222,0.15);padding:6px 14px;margin-left:-13px;border-radius:50px}.cz-cpt-post .cz_default_loop .cz_post_title h3{font-size:28px;line-height:34px;margin-top:30px;margin-right:30px;margin-left:30px}#menu_header_2 .cz .cz a .cz_indicator{color:#ffffff}.cz_default_loop.sticky > div{background-color:rgba(79,92,222,0.04);margin-bottom:40px;border-style:solid;border-width:2px;border-color:#000370;border-radius:10px}.cz-cpt-post .cz_default_loop > div{background-color:rgba(79,92,222,0.06);margin-bottom:0px;border-style:none;border-radius:10px}.cz-cpt-post .cz_default_loop .cz_post_meta{margin-right:30px;margin-left:30px;border-width:0px 0px 0px 6px;border-color:#4f5cde;display:inline-block}#comments > h3,.content.cz_related_posts > h4,.content.cz_author_box > h4,.related.products > h2,.upsells.products > h2,.up-sells.products > h2,.up-sells.products > h2,.woocommerce-page .cart-collaterals .cart_totals > h2,.woocommerce-page #customer_details > div:first-child > div:first-child > h3:first-child,.woocommerce-page .codevz-checkout-details > h3,.woocommerce-page .woocommerce-order-details > h2,.woocommerce-page .woocommerce-customer-details > h2,.woocommerce-page .cart-collaterals .cross-sells > h2{font-size:18px;color:#ffffff;background-color:#4f5cde;padding:15px 30px;margin:-30px -30px 30px;border-style:solid;border-bottom-width:0px;border-radius:10px 10px 0 0}.next_prev .previous i,.next_prev .next i{color:#ffffff;background-color:#4f5cde;border-style:solid;border-width:1px;border-color:#4f5cde;border-radius:50px;box-shadow:0px 10px 30px rgba(79,92,222,0.5)}.next_prev .previous:hover i,.next_prev .next:hover i{color:#4f5cde;background-color:#ffffff;border-style:solid;border-color:#4f5cde;box-shadow:none}.next_prev h4{margin-right:8px;margin-left:8px} .content .xtra-post-title,  .content .section_title{font-size:32px}.single .content .xtra-post-title{font-size:32px}.page_header{background-color:transparent;background-image:linear-gradient(180deg,rgba(0,0,0,0.1),rgba(255,255,255,0.01))}.elms_row .cz_social a, .fixed_side .cz_social a, #xtra-social-popup [class*=\"xtra-social-type-\"] a{color:#4f5cde;margin-right:2px;margin-left:2px;border-style:solid;border-width:1px;border-color:rgba(79,92,222,0.2);border-radius:50px}.elms_row .cz_social a:hover, .fixed_side .cz_social a:hover, #xtra-social-popup [class*=\"xtra-social-type-\"] a:hover{color:#ffffff;background-color:#282828;box-shadow:0px 10px 30px rgba(79,92,222,0.5)}[class*=\"cz_tooltip_\"] [data-title]:after{font-size:11px;color:#ffffff;font-weight:500;background-color:#4f5cde;padding:8px 14px 9px;border-radius:50px}.footer_2 .row{border-style:solid;border-top-width:1px;border-color:#e5e5e5}#menu_footer_1 > .cz > a{color:#969696;margin-right:15px;margin-left:15px}#menu_footer_1 > .cz > a:hover,#menu_footer_1 > .cz:hover > a,#menu_footer_1 > .cz.current_menu > a,#menu_footer_1 > .current-menu-parent > a{color:#4f5cde}#menu_footer_1 > .cz > a:before{display:none}i.backtotop:hover{background-color:#222222;box-shadow:0px 5px 30px 0px rgba(79,92,222,0.5)}form button,.comment-form button,a.cz_btn,div.cz_btn,a.cz_btn_half_to_fill:before,a.cz_btn_half_to_fill_v:before,a.cz_btn_half_to_fill:after,a.cz_btn_half_to_fill_v:after,a.cz_btn_unroll_v:before, a.cz_btn_unroll_h:before,a.cz_btn_fill_up:before,a.cz_btn_fill_down:before,a.cz_btn_fill_left:before,a.cz_btn_fill_right:before,.wpcf7-submit,input[type=submit],input[type=button],.button,.cz_header_button,.woocommerce a.button,.woocommerce input.button,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, #edd-purchase-button, .edd-submit, [type=submit].edd-submit, .edd-submit.button.blue,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce button.button:disabled, .woocommerce button.button:disabled[disabled], .woocommerce a.button.wc-forward,.wp-block-search .wp-block-search__button,.woocommerce-message a.restore-item.button{font-weight:700;border-style:solid;border-width:1px;border-color:#4f5cde;border-radius:100px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}#menu_header_4{background-color:#4f5cde;padding-top:30px;padding-bottom:30px}#menu_footer_1{margin-right:-15px;margin-bottom:15px;margin-left:-15px}#menu_footer_1 > .cz{text-align:justify;display:inline-block;float:none}.page_content img, a.cz_post_image img, footer img, .cz_image_in, .wp-block-gallery figcaption, .cz_grid .cz_grid_link{border-radius:10px}.cz-cpt-post .cz_post_image, .cz-cpt-post .cz_post_svg{margin-bottom:0px;border-radius:10px 10px 0 0}form button:hover,.comment-form button:hover,a.cz_btn:hover,div.cz_btn:hover,a.cz_btn_half_to_fill:hover:before, a.cz_btn_half_to_fill_v:hover:before,a.cz_btn_half_to_fill:hover:after, a.cz_btn_half_to_fill_v:hover:after,a.cz_btn_unroll_v:after, a.cz_btn_unroll_h:after,a.cz_btn_fill_up:after,a.cz_btn_fill_down:after,a.cz_btn_fill_left:after,a.cz_btn_fill_right:after,.wpcf7-submit:hover,input[type=submit]:hover,input[type=button]:hover,.button:hover,.cz_header_button:hover,.woocommerce a.button:hover,.woocommerce input.button:hover,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, #edd-purchase-button:hover, .edd-submit:hover, [type=submit].edd-submit:hover, .edd-submit.button.blue:hover, .edd-submit.button.blue:focus,.woocommerce #payment #place_order:hover, .woocommerce-page #payment #place_order:hover,.woocommerce div.product form.cart .button:hover,.woocommerce button.button:disabled:hover, .woocommerce button.button:disabled[disabled]:hover, .woocommerce a.button.wc-forward:hover,.wp-block-search .wp-block-search__button:hover,.woocommerce-message a.restore-item.button:hover{color:#4f5cde;background-color:#ffffff;border-style:solid;border-color:#ffffff}input,textarea,select,.qty,.woocommerce-input-wrapper .select2-selection--single,#add_payment_method table.cart td.actions .coupon .input-text, .woocommerce-cart table.cart td.actions .coupon .input-text, .woocommerce-checkout table.cart td.actions .coupon .input-text{color:#212121;padding-right:15px;padding-left:15px;border-radius:20px}.cz-cpt-post .cz_readmore i, .cz-cpt-post .more-link i{color:#ffffff}.cz-cpt-post .cz_default_loop .cz_post_excerpt{margin-right:30px;margin-left:30px}.tagcloud a, .widget .tagcloud a, .cz_post_cat a, .cz_post_views a{padding:2px 15px;border-radius:50px}.cz_related_posts .cz_related_post .cz_post_image{margin-bottom:30px;border-radius:10px}.xtra-comments .commentlist li article{background-color:#ffffff;border-style:none;border-radius:10px}.page_title .row{padding-top:10px;padding-bottom:10px;border-style:solid;border-top-width:1px;border-bottom-width:1px;border-color:rgba(79,92,222,0.15)}.cz-cpt-post article .cz_post_icon{color:#4f5cde;background-color:#ffffff}.cz-cpt-post .cz_readmore:hover i, .cz-cpt-post .more-link:hover i{color:#4f5cde}.single_con .tagcloud a:first-child, .single_con .cz_post_cat a:first-child, .cz_post_views a:first-child{text-align:center;width:30px;padding-right:0px;padding-left:0px}div.xtra-share{background-color:rgba(79,92,222,0.06);padding-top:60px;padding-bottom:20px;margin-bottom:24px;border-style:none;border-radius:10px;display:flex}div.xtra-share a{border-radius:99px}.xtra-comments,.content.cz_related_posts,.cz_author_box,.related.products,.upsells.products,.up-sells.products,.woocommerce-page .cart-collaterals .cart_totals,.woocommerce-page #customer_details,.woocommerce-page .codevz-checkout-details,.woocommerce-page .woocommerce-order-details,.woocommerce-page .woocommerce-customer-details,.woocommerce-page .cart-collaterals .cross-sells,.woocommerce-account .cz_post_content > .woocommerce{background-color:rgba(79,92,222,0.06);padding:30px 30px 0px;margin-bottom:24px;border-radius:10px}div.xtra-share a:hover{box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}#xtra_quick_view .cz_popup_in, #xtra_wish_compare .cz_popup_in{border-radius:10px}.products .product .xtra-product-icons{padding:5px;margin-right:12px;margin-left:12px;border-radius:100px}.products .product .xtra-add-to-wishlist{border-radius:100px}.products .product .xtra-add-to-wishlist:hover{color:#4f5cde;background-color:#ffffff}.products .product .xtra-product-quick-view{border-radius:100px}.products .product .xtra-product-quick-view:hover{color:#4f5cde;background-color:#ffffff}.woocommerce ul.products li.product .woocommerce-loop-product__link{border-style:solid;border-width:3px;border-color:rgba(79,92,222,0.1);border-radius:12px}.woocommerce ul.products li.product:hover .woocommerce-loop-product__link{border-style:solid;border-color:#4f5cde}.woocommerce .cart .xtra-product-icons-wishlist{border-radius:100px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}.woocommerce .cart .xtra-product-icons-wishlist:hover{color:#4f5cde;background-color:#ffffff}.woocommerce .quantity .qty{width:140px;margin-right:-40px;margin-left:-40px}.quantity-down{padding:8px;margin-left:5px;border-radius:100px}.rtl .quantity-down{margin-left:0px;margin-right:5px}.quantity-down:hover{color:#ffffff;background-color:#4f5cde;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}.quantity-up{padding:8px;margin-right:5px;border-radius:100px}.rtl .quantity-up{margin-right:0px;margin-left:5px}.quantity-up:hover{color:#ffffff;background-color:#4f5cde;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}div.xtra-share:before{font-size:16px;color:#ffffff;text-align:right;font-weight:700;background-color:#4f5cde;width:100%;padding:6px 30px;border-style:solid;border-width:0px 0px 1px;border-color:rgba(77,97,255,0.31);border-radius:10px 10px 0 0;position:absolute;top:0px;right:0px;box-sizing:border-box}.woocommerce div.product .woocommerce-tabs ul.tabs li{background-color:rgba(79,92,222,0.06);border-style:none;border-radius:10px 10px 0 0}.woocommerce div.product .woocommerce-tabs ul.tabs li.active{color:#ffffff;background-color:#4f5cde}.woocommerce div.product .woocommerce-tabs .panel{background-color:rgba(79,92,222,0.06);border-style:none;border-radius:0 0 10px 10px}.woocommerce div.product .product_title{font-size:20px;padding-top:10px}.xtra-mobile-menu-text{color:#d6d6d6;padding-top:10px;padding-bottom:20px}li.xtra-mobile-menu-additional .cz_social a{font-size:18px;color:#ffffff;background-color:rgba(255,255,255,0.1);padding:5px;margin-right:4px;margin-left:4px;border-radius:100px}li.xtra-mobile-menu-additional .cz_social a:hover{color:#ffffff;background-color:#000000}.xtra-fixed-mobile-nav{background-color:#4f5cde;border-radius:10px 10px 0 0;box-shadow:0px -10px 30px 0px rgba(79,92,222,0.06)}.xtra-fixed-mobile-nav a i, .xtra-fixed-mobile-nav a img{background-color:rgba(255,255,255,0.1);padding:10px;margin-bottom:5px;border-radius:100px}.xtra-fixed-mobile-nav a:hover i, .xtra-fixed-mobile-nav a:hover img, .xtra-fixed-mobile-nav .xtra-active i, .xtra-fixed-mobile-nav .xtra-active img{color:#4f5cde;background-color:#ffffff}.woocommerce.single span.onsale{right:10px;left:auto}.products .product .xtra-add-to-compare{border-radius:100px}.products .product .xtra-add-to-compare:hover{color:#4f5cde;background-color:#ffffff}.woocommerce .cart .xtra-product-icons-compare{border-radius:100px;box-shadow:0px 10px 30px 0px rgba(79,92,222,0.5)}.woocommerce .cart .xtra-product-icons-compare:hover{color:#4f5cde;background-color:#ffffff}\n\n/* Responsive */@media screen and (max-width:1240px){#layout{width:100%!important}#layout.layout_1,#layout.layout_2{width:95%!important}.row{width:90% !important;padding:0}blockquote{padding:20px}footer .elms_center,footer .have_center .elms_left, footer .have_center .elms_center, footer .have_center .elms_right{float:none;display:block;text-align:center;margin:0 auto;flex:unset}}@media screen and (max-width:768px){}@media screen and (max-width:480px){.breadcrumbs{display:none;}.cz-cpt-post .cz_default_loop > div{margin-bottom:30px;}}\";s:3:\"rtl\";b:1;s:4:\"dark\";b:0;s:11:\"share_title\";b:0;s:22:\"white_label_theme_name\";s:0:\"\";s:29:\"white_label_theme_description\";s:0:\"\";s:11:\"magic_mouse\";b:0;s:19:\"disable_rtl_numbers\";b:0;s:6:\"logo_2\";s:54:\"http://localhost/wp-content/uploads/2024/06/header.png\";s:20:\"cf7_beside_backtotop\";s:10:\"اتصال\";s:13:\"layout_search\";s:2:\"ws\";s:17:\"disable_portfolio\";b:0;s:14:\"layout_product\";s:2:\"ws\";s:11:\"woo_orderby\";s:4:\"date\";s:22:\"woo_wishlist_qv_center\";b:1;s:21:\"layout_single_product\";s:2:\"ws\";s:20:\"woo_gallery_features\";a:1:{i:0;s:4:\"zoom\";}s:16:\"woo_product_tabs\";s:6:\"center\";}","on");

INSERT IGNORE INTO `moyhd_options` VALUES 
("209","codevz_move__custom_sidebars_to_options","1","yes"),
("210","codevz_first_time_options_backup","a:2:{i:0;b:0;s:15:\"custom_sidebars\";a:1:{i:0;b:0;}}","yes"),
("216","elementor_active_kit","830","yes"),
("217","elementor_font_display","swap","yes"),
("220","elementor_version","3.26.3","yes"),
("221","elementor_install_history","a:13:{s:6:\"3.22.1\";i:1718978266;s:6:\"3.22.2\";i:1719248895;s:6:\"3.22.3\";i:1719568411;s:6:\"3.23.1\";i:1721638662;s:6:\"3.23.2\";i:1721840219;s:6:\"3.23.3\";i:1721936096;s:6:\"3.23.4\";i:1722869378;s:6:\"3.24.1\";i:1726234269;s:6:\"3.24.2\";i:1726234549;s:6:\"3.25.1\";i:1730174367;s:6:\"3.26.0\";i:1734585638;s:6:\"3.26.2\";i:1734692869;s:6:\"3.26.3\";i:1734929776;}","yes"),
("222","elementor_events_db_version","1.0.0","no"),
("227","revslider_servers","a:4:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:16:\"themepunch.tools\";}","yes"),
("228","revslider_server_refresh","1718978269","yes"),
("229","revslider-update-check-short","1718978269","yes"),
("230","revslider-connection","1","yes"),
("231","revslider-update-hash","ac1167a914986f4394ec449ef1ff5ad5","yes"),
("232","revslider-latest-version","6.7.13","yes"),
("233","revslider-stable-version","4.2.0","yes"),
("234","revslider-notices","a:2:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-a.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}","yes"),
("235","revslider-additions","O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}","yes"),
("236","rs-addons-counter","35","yes"),
("237","revslider-addons","O:8:\"stdClass\":35:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-05-07\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-04-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"568\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2024-05-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-06-10\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-06-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-06-07\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"557\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:81:\"//updates.themepunch-ext-a.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-05-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2023-12-11\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2023-08-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-04-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}","yes"),
("238","revslider-library-check","1718978269","yes"),
("239","revslider-library-hash","dae3de1eb57eeeee008b70e9a23844b5","yes"),
("240","rs-library","a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","no");

INSERT IGNORE INTO `moyhd_options` VALUES 
("241","revslider-templates-check","1718978269","yes"),
("242","revslider-templates-hash","adb124a80d1ef0a591c3197a97b2d096","yes"),
("243","rs-templates-new","","no"),
("244","rs-templates","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","no"),
("245","rs-templates-counter","729","no"),
("247","revslider-global-settings","{\"getTec\":{\"engine\":\"SR7\"},\"version\":\"6.2.0\"}","yes"),
("250","revslider_update_version","6.6.21","yes"),
("251","widget_rev-slider-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("252","rs_cache_overlay","1.0.0","yes"),
("253","revslider-update-check","1718978269","yes"),
("254","revslider_update_info","O:8:\"stdClass\":0:{}","yes"),
("257","action_scheduler_hybrid_store_demarkation","10","yes"),
("258","schema-ActionScheduler_StoreSchema","7.0.1718978282","yes"),
("259","schema-ActionScheduler_LoggerSchema","3.0.1718978282","yes"),
("262","woocommerce_newly_installed","no","yes"),
("263","woocommerce_schema_version","920","yes"),
("264","woocommerce_store_address","","yes"),
("265","woocommerce_store_address_2","","yes"),
("266","woocommerce_store_city","","yes"),
("267","woocommerce_default_country","IR:THR","yes"),
("268","woocommerce_store_postcode","","yes"),
("269","woocommerce_allowed_countries","specific","yes"),
("270","woocommerce_all_except_countries","a:0:{}","yes"),
("271","woocommerce_specific_allowed_countries","a:1:{i:0;s:2:\"IR\";}","yes"),
("272","woocommerce_ship_to_countries","disabled","yes"),
("273","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("274","woocommerce_default_customer_address","","yes"),
("275","woocommerce_calc_taxes","no","yes"),
("276","woocommerce_enable_coupons","yes","yes"),
("277","woocommerce_calc_discounts_sequentially","no","no"),
("278","woocommerce_currency","IRT","yes"),
("279","woocommerce_currency_pos","left","yes"),
("280","woocommerce_price_thousand_sep","","yes"),
("281","woocommerce_price_decimal_sep","","yes"),
("282","woocommerce_price_num_decimals","0","yes"),
("283","woocommerce_shop_page_id","715","yes"),
("284","woocommerce_cart_redirect_after_add","yes","yes"),
("285","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("286","woocommerce_placeholder_image","657","yes"),
("287","woocommerce_weight_unit","kg","yes"),
("288","woocommerce_dimension_unit","cm","yes"),
("289","woocommerce_enable_reviews","no","on"),
("290","woocommerce_review_rating_verification_label","yes","no"),
("291","woocommerce_review_rating_verification_required","no","no"),
("292","woocommerce_enable_review_rating","no","yes"),
("293","woocommerce_review_rating_required","no","no"),
("294","woocommerce_manage_stock","no","yes"),
("295","woocommerce_hold_stock_minutes","60","no"),
("296","woocommerce_notify_low_stock","yes","no"),
("297","woocommerce_notify_no_stock","yes","no"),
("298","woocommerce_stock_email_recipient","support@gtaall.ir","no"),
("299","woocommerce_notify_low_stock_amount","2","no"),
("300","woocommerce_notify_no_stock_amount","0","yes"),
("301","woocommerce_hide_out_of_stock_items","no","yes"),
("302","woocommerce_stock_format","no_amount","yes"),
("303","woocommerce_file_download_method","redirect","off"),
("304","woocommerce_downloads_redirect_fallback_allowed","no","no"),
("305","woocommerce_downloads_require_login","no","off"),
("306","woocommerce_downloads_grant_access_after_payment","no","no"),
("307","woocommerce_downloads_deliver_inline","no","off"),
("308","woocommerce_downloads_add_hash_to_filename","no","on"),
("310","woocommerce_attribute_lookup_direct_updates","no","yes"),
("311","woocommerce_product_match_featured_image_by_sku","no","yes"),
("312","woocommerce_prices_include_tax","no","yes"),
("313","woocommerce_tax_based_on","shipping","yes"),
("314","woocommerce_shipping_tax_class","inherit","yes"),
("315","woocommerce_tax_round_at_subtotal","no","yes"),
("316","woocommerce_tax_classes","","yes"),
("317","woocommerce_tax_display_shop","excl","yes"),
("318","woocommerce_tax_display_cart","excl","yes"),
("319","woocommerce_price_display_suffix","","yes"),
("320","woocommerce_tax_total_display","itemized","no"),
("321","woocommerce_enable_shipping_calc","yes","no"),
("322","woocommerce_shipping_cost_requires_address","no","yes"),
("323","woocommerce_ship_to_destination","billing","no"),
("324","woocommerce_shipping_debug_mode","no","yes"),
("325","woocommerce_enable_guest_checkout","yes","no"),
("326","woocommerce_enable_checkout_login_reminder","no","no"),
("327","woocommerce_enable_signup_and_login_from_checkout","no","no");

INSERT IGNORE INTO `moyhd_options` VALUES 
("328","woocommerce_enable_myaccount_registration","no","no"),
("329","woocommerce_registration_generate_username","no","no"),
("330","woocommerce_registration_generate_password","no","no"),
("331","woocommerce_erasure_request_removes_order_data","no","no"),
("332","woocommerce_erasure_request_removes_download_data","no","no"),
("333","woocommerce_allow_bulk_remove_personal_data","no","no"),
("334","woocommerce_registration_privacy_policy_text","اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.","yes"),
("335","woocommerce_checkout_privacy_policy_text","با تکمیل سفارش شما تمامی قوانین فروشگاه را تایید کرده و هیچگونه جای شکایتی باقی نمی ماند","yes"),
("336","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("337","woocommerce_trash_pending_orders","a:2:{s:6:\"number\";i:3;s:4:\"unit\";s:4:\"days\";}","no"),
("338","woocommerce_trash_failed_orders","a:2:{s:6:\"number\";i:3;s:4:\"unit\";s:4:\"days\";}","no"),
("339","woocommerce_trash_cancelled_orders","a:2:{s:6:\"number\";i:3;s:4:\"unit\";s:4:\"days\";}","no"),
("340","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("341","woocommerce_email_from_name","معرفی سرور ام تی ای","no"),
("342","woocommerce_email_from_address","support@gtaall.ir","no"),
("343","woocommerce_email_header_image","","no"),
("344","woocommerce_email_footer_text","قالب وب سایت توسط تیم داچ وب طراحی شده است","no"),
("345","woocommerce_email_base_color","#4f5cde","no"),
("346","woocommerce_email_background_color","#f7f7f7","no"),
("347","woocommerce_email_body_background_color","#ffffff","no"),
("348","woocommerce_email_text_color","#3c3c3c","no"),
("349","woocommerce_merchant_email_notifications","no","no"),
("350","woocommerce_cart_page_id","716","no"),
("351","woocommerce_checkout_page_id","717","no"),
("352","woocommerce_myaccount_page_id","718","no"),
("353","woocommerce_terms_page_id","","no"),
("354","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("355","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("356","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("357","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("358","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("359","woocommerce_myaccount_orders_endpoint","orders","yes"),
("360","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("361","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("362","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("363","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("364","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("365","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("366","woocommerce_logout_endpoint","customer-logout","yes"),
("367","woocommerce_api_enabled","no","yes"),
("368","woocommerce_allow_tracking","no","on"),
("369","woocommerce_show_marketplace_suggestions","yes","no"),
("370","woocommerce_custom_orders_table_enabled","yes","yes"),
("371","woocommerce_analytics_enabled","yes","yes"),
("372","woocommerce_feature_order_attribution_enabled","yes","yes"),
("373","woocommerce_feature_product_block_editor_enabled","no","yes"),
("374","woocommerce_hpos_fts_index_enabled","no","yes"),
("375","woocommerce_single_image_width","600","yes"),
("376","woocommerce_thumbnail_image_width","600","yes"),
("377","woocommerce_checkout_highlight_required_fields","no","yes"),
("378","woocommerce_demo_store","no","no"),
("379","wc_downloads_approved_directories_mode","enabled","yes"),
("380","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("381","current_theme_supports_woocommerce","yes","yes"),
("382","woocommerce_queue_flush_rewrite_rules","no","yes"),
("385","default_product_cat","15","yes"),
("387","woocommerce_refund_returns_page_id","15","yes"),
("390","woocommerce_paypal_settings","a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:17:\"support@gtaall.ir\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:17:\"support@gtaall.ir\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}","yes"),
("391","woocommerce_version","9.5.1","yes"),
("392","woocommerce_db_version","9.5.1","yes"),
("393","woocommerce_store_id","f3466b3c-21e5-4fd2-867f-3db045f24324","yes"),
("394","woocommerce_admin_install_timestamp","1718978283","yes"),
("395","woocommerce_inbox_variant_assignment","10","yes"),
("396","woocommerce_remote_variant_assignment","30","yes"),
("401","action_scheduler_lock_async-request-runner","6768efdfd81ff2.09878887|1734930459","no"),
("402","woocommerce_admin_notices","a:1:{i:0;s:24:\"redirect_download_method\";}","yes"),
("403","wc_blocks_version","11.8.0-dev","yes"),
("404","jetpack_connection_active_plugins","a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:14:\"ووکامرس\";}}","yes"),
("405","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"shsVoP9TTabXvcrVhhVeymKuQf2ZPD9D\";}","yes"),
("407","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("408","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("409","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("410","widget_woocommerce_price_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("411","widget_woocommerce_product_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("412","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("413","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("414","widget_woocommerce_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("415","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("416","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("417","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("418","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("422","wc_admin_show_legacy_coupon_menu","0","yes"),
("423","woocommerce_custom_orders_table_created","yes","yes"),
("424","wc_blocks_db_schema_version","260","yes"),
("425","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}","no"),
("428","xtra-downloaded-demo","cryptocurrency","yes"),
("429","xtra-downloaded-folder","rtl-elementor","yes"),
("434","wcpay_was_in_use","no","yes"),
("443","jetpack_options","a:1:{s:14:\"last_heartbeat\";i:1734847966;}","yes"),
("456","wpcf7","a:2:{s:7:\"version\";s:5:\"6.0.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1718978323;s:7:\"version\";s:5:\"5.9.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes"),
("457","codevz_demo_path","/home/wantedrp/public_html/wp-content/uploads/codevz_demo_data/cryptocurrency/","yes"),
("458","codevz_primary_color","#4f5cde","yes"),
("459","xtra_uninstall_cryptocurrency","a:6:{i:0;b:0;s:7:\"options\";a:2:{i:0;a:1:{s:7:\"options\";b:1;}i:1;a:1:{s:7:\"options\";b:1;}}s:5:\"terms\";a:34:{i:0;a:2:{s:2:\"id\";i:16;s:8:\"taxonomy\";s:8:\"category\";}i:1;a:2:{s:2:\"id\";i:17;s:8:\"taxonomy\";s:8:\"category\";}i:2;a:2:{s:2:\"id\";i:18;s:8:\"taxonomy\";s:8:\"category\";}i:3;a:2:{s:2:\"id\";i:19;s:8:\"taxonomy\";s:8:\"category\";}i:4;a:2:{s:2:\"id\";i:20;s:8:\"taxonomy\";s:8:\"post_tag\";}i:5;a:2:{s:2:\"id\";i:21;s:8:\"taxonomy\";s:8:\"post_tag\";}i:6;a:2:{s:2:\"id\";i:22;s:8:\"taxonomy\";s:8:\"post_tag\";}i:7;a:2:{s:2:\"id\";i:23;s:8:\"taxonomy\";s:8:\"post_tag\";}i:8;a:2:{s:2:\"id\";i:24;s:8:\"taxonomy\";s:8:\"post_tag\";}i:9;a:2:{s:2:\"id\";i:25;s:8:\"taxonomy\";s:8:\"post_tag\";}i:10;a:2:{s:2:\"id\";i:26;s:8:\"taxonomy\";s:8:\"post_tag\";}i:11;a:2:{s:2:\"id\";i:27;s:8:\"taxonomy\";s:8:\"post_tag\";}i:12;a:2:{s:2:\"id\";i:28;s:8:\"taxonomy\";s:8:\"post_tag\";}i:13;a:2:{s:2:\"id\";i:29;s:8:\"taxonomy\";s:8:\"post_tag\";}i:14;a:2:{s:2:\"id\";i:30;s:8:\"taxonomy\";s:11:\"product_cat\";}i:15;a:2:{s:2:\"id\";i:31;s:8:\"taxonomy\";s:11:\"product_tag\";}i:16;a:2:{s:2:\"id\";i:32;s:8:\"taxonomy\";s:11:\"product_tag\";}i:17;a:2:{s:2:\"id\";i:33;s:8:\"taxonomy\";s:11:\"product_tag\";}i:18;a:2:{s:2:\"id\";i:34;s:8:\"taxonomy\";s:11:\"product_tag\";}i:19;a:2:{s:2:\"id\";i:35;s:8:\"taxonomy\";s:11:\"product_tag\";}i:20;a:2:{s:2:\"id\";i:36;s:8:\"taxonomy\";s:11:\"product_cat\";}i:21;a:2:{s:2:\"id\";i:37;s:8:\"taxonomy\";s:11:\"product_tag\";}i:22;a:2:{s:2:\"id\";i:38;s:8:\"taxonomy\";s:11:\"product_tag\";}i:23;a:2:{s:2:\"id\";i:39;s:8:\"taxonomy\";s:11:\"product_tag\";}i:24;a:2:{s:2:\"id\";i:40;s:8:\"taxonomy\";s:11:\"product_tag\";}i:25;a:2:{s:2:\"id\";i:41;s:8:\"taxonomy\";s:11:\"product_cat\";}i:26;a:2:{s:2:\"id\";i:42;s:8:\"taxonomy\";s:11:\"product_cat\";}i:27;a:2:{s:2:\"id\";i:43;s:8:\"taxonomy\";s:11:\"product_cat\";}i:28;a:2:{s:2:\"id\";i:44;s:8:\"taxonomy\";s:11:\"product_tag\";}i:29;a:2:{s:2:\"id\";i:45;s:8:\"taxonomy\";s:11:\"product_tag\";}i:30;a:2:{s:2:\"id\";i:46;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:31;a:2:{s:2:\"id\";i:47;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:32;a:2:{s:2:\"id\";i:48;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:33;a:2:{s:2:\"id\";i:49;s:8:\"taxonomy\";s:8:\"nav_menu\";}}s:5:\"posts\";a:37:{i:0;a:2:{s:2:\"id\";i:830;s:5:\"title\";s:109:\"%d8%a7%d9%84%d9%85%d8%ac%d9%85%d9%88%d8%b9%d8%a9-%d8%a7%d9%84%d8%a7%d9%81%d8%aa%d8%b1%d8%a7%d8%b6%d9%8a%d8%a9\";}i:1;a:2:{s:2:\"id\";i:831;s:5:\"title\";s:165:\"%d8%a7%d9%84%d8%b9%d9%85%d9%84%d8%a9-%d8%a7%d9%84%d9%85%d8%b4%d9%81%d8%b1%d8%a9-%d8%a7%d9%84%d8%b5%d9%81%d8%ad%d8%a9-%d8%a7%d9%84%d8%b1%d8%a6%d9%8a%d8%b3%d9%8a%d8%a9\";}i:2;a:2:{s:2:\"id\";i:832;s:5:\"title\";s:117:\"%d8%a7%d9%84%d8%b9%d9%85%d9%84%d8%a9-%d8%a7%d9%84%d9%85%d8%b4%d9%81%d8%b1%d8%a9-%d8%b4%d9%87%d8%a7%d8%af%d8%a9-%d9%a3\";}i:3;a:2:{s:2:\"id\";i:833;s:5:\"title\";s:117:\"%d8%a7%d9%84%d8%b9%d9%85%d9%84%d8%a9-%d8%a7%d9%84%d9%85%d8%b4%d9%81%d8%b1%d8%a9-%d8%b4%d9%87%d8%a7%d8%af%d8%a9-%d9%a2\";}i:4;a:2:{s:2:\"id\";i:834;s:5:\"title\";s:117:\"%d8%a7%d9%84%d8%b9%d9%85%d9%84%d8%a9-%d8%a7%d9%84%d9%85%d8%b4%d9%81%d8%b1%d8%a9-%d8%b4%d9%87%d8%a7%d8%af%d8%a9-%d9%a1\";}i:5;a:2:{s:2:\"id\";i:835;s:5:\"title\";s:68:\"%d9%85%d8%ab%d8%a7%d9%84-%d8%b9%d9%84%d9%89-%d8%b5%d9%81%d8%ad%d8%a9\";}i:6;a:2:{s:2:\"id\";i:836;s:5:\"title\";s:85:\"%d8%a7%d9%84%d8%b5%d9%81%d8%ad%d8%a9-%d8%a7%d9%84%d8%b1%d8%a6%d9%8a%d8%b3%d9%8a%d8%a9\";}i:7;a:2:{s:2:\"id\";i:8;s:5:\"title\";s:184:\"%d9%85%d9%82%d8%af%d9%85%d8%a9-%d9%81%d9%8a-%d8%a7%d9%84%d8%a8%d9%86%d9%88%d9%83-%d9%88%d8%a7%d9%84%d8%b9%d9%85%d9%84%d9%8a%d8%a7%d8%aa-%d8%a7%d9%84%d9%85%d8%b5%d8%b1%d9%81%d9%8a%d8%a9\";}i:8;a:2:{s:2:\"id\";i:191;s:5:\"title\";s:54:\"%d8%a7%d9%84%d8%a7%d8%b3%d8%aa%d8%ab%d9%85%d8%a7%d8%b1\";}i:9;a:2:{s:2:\"id\";i:513;s:5:\"title\";s:37:\"%d8%b9%d9%86-%d9%87%d9%8a%d8%a6%d8%a9\";}i:10;a:2:{s:2:\"id\";i:517;s:5:\"title\";s:30:\"%d8%a7%d8%aa%d8%b5%d8%a7%d9%84\";}i:11;a:2:{s:2:\"id\";i:521;s:5:\"title\";s:54:\"%d8%a7%d9%84%d8%a5%d8%ae%d8%a8%d8%a7%d8%b1%d9%8a%d8%a9\";}i:12;a:2:{s:2:\"id\";i:715;s:5:\"title\";s:36:\"%d8%a7%d9%84%d9%85%d8%aa%d8%ac%d8%b1\";}i:13;a:2:{s:2:\"id\";i:716;s:5:\"title\";s:73:\"%d8%b3%d9%84%d8%a9-%d8%a7%d9%84%d9%85%d8%b4%d8%aa%d8%b1%d9%8a%d8%a7%d8%aa\";}i:14;a:2:{s:2:\"id\";i:717;s:5:\"title\";s:61:\"%d8%a5%d8%aa%d9%85%d8%a7%d9%85-%d8%a7%d9%84%d8%b7%d9%84%d8%a8\";}i:15;a:2:{s:2:\"id\";i:718;s:5:\"title\";s:30:\"%d8%ad%d8%b3%d8%a7%d8%a8%d9%8a\";}i:16;a:2:{s:2:\"id\";i:794;s:5:\"title\";s:73:\"%d9%82%d8%a7%d8%a6%d9%85%d8%a9-%d8%a7%d9%84%d8%b1%d8%ba%d8%a8%d8%a7%d8%aa\";}i:17;a:2:{s:2:\"id\";i:1141;s:5:\"title\";s:8:\"wishlist\";}i:18;a:2:{s:2:\"id\";i:10;s:5:\"title\";s:75:\"%d9%86%d9%85%d9%88%d8%b0%d8%ac-%d8%a7%d9%84%d8%a7%d8%aa%d8%b5%d8%a7%d9%84-1\";}i:19;a:2:{s:2:\"id\";i:43;s:5:\"title\";s:80:\"%d8%a7%d9%84%d8%ad%d8%b2%d9%85%d8%a9-%d8%a7%d9%84%d8%ae%d8%a7%d8%b5%d8%a9-%d9%a3\";}i:20;a:2:{s:2:\"id\";i:96;s:5:\"title\";s:31:\"%d9%85%d9%86%d8%aa%d8%ac-%d9%a3\";}i:21;a:2:{s:2:\"id\";i:99;s:5:\"title\";s:93:\"%d8%a8%d8%a7%d9%82%d8%a9-%d8%b0%d8%a7%d8%aa-%d8%b1%d9%82%d9%85-%d9%85%d8%ad%d8%af%d9%88%d8%af\";}i:22;a:2:{s:2:\"id\";i:105;s:5:\"title\";s:67:\"%d8%a7%d9%84%d9%85%d9%86%d8%aa%d8%ac-%d8%a7%d9%84%d8%a3%d9%88%d9%84\";}i:23;a:2:{s:2:\"id\";i:108;s:5:\"title\";s:80:\"%d8%a8%d8%a7%d9%82%d8%a9-%d8%ba%d9%8a%d8%b1-%d9%85%d8%ad%d8%af%d9%88%d8%af%d8%a9\";}i:24;a:2:{s:2:\"id\";i:121;s:5:\"title\";s:43:\"%d9%85%d9%86%d8%aa%d8%ac-%d8%ae%d8%a7%d8%b5\";}i:25;a:2:{s:2:\"id\";i:140;s:5:\"title\";s:98:\"%d9%86%d9%85%d8%a7%d8%b0%d8%ac-%d8%a7%d9%85%d8%aa%d8%ad%d8%a7%d9%86%d8%a7%d8%aa-%d8%a7%d8%af%d8%b1\";}i:26;a:2:{s:2:\"id\";i:148;s:5:\"title\";s:81:\"%d9%87%d8%b0%d8%a7-%d8%a7%d9%84%d9%86%d8%b5-%d9%87%d9%88-%d9%85%d8%ab%d8%a7%d9%84\";}i:27;a:2:{s:2:\"id\";i:153;s:5:\"title\";s:49:\"%d8%af%d8%b1%d8%a8-%d8%af%d9%85%d8%a7%d8%ba%d9%83\";}i:28;a:2:{s:2:\"id\";i:158;s:5:\"title\";s:99:\"%d9%82%d9%84-%d9%85%d8%aa%d8%a7%d8%b9-%d8%a7%d9%84%d8%af%d9%86%d9%8a%d8%a7-%d9%82%d9%84%d9%8a%d9%84\";}i:29;a:2:{s:2:\"id\";i:163;s:5:\"title\";s:55:\"%d9%86%d8%b9%d9%85-%d8%aa%d8%b3%d8%aa%d8%b7%d9%8a%d8%b9\";}i:30;a:2:{s:2:\"id\";i:213;s:5:\"title\";s:18:\"cf7-contact-form-1\";}i:31;a:2:{s:2:\"id\";i:504;s:5:\"title\";s:22:\"cf7-quick-contact-form\";}i:32;a:2:{s:2:\"id\";i:774;s:5:\"title\";s:73:\"%d8%a7%d9%84%d8%ad%d8%b2%d9%85%d8%a9-%d8%a7%d9%84%d8%ae%d8%a7%d8%b5%d8%a9\";}i:33;a:2:{s:2:\"id\";i:775;s:5:\"title\";s:31:\"%d9%85%d9%86%d8%aa%d8%ac-%d9%a2\";}i:34;a:2:{s:2:\"id\";i:776;s:5:\"title\";s:61:\"%d9%85%d8%ac%d9%85%d9%88%d8%b9%d8%a9-%d8%ae%d8%a7%d8%b5%d8%a9\";}i:35;a:2:{s:2:\"id\";i:777;s:5:\"title\";s:80:\"%d8%a7%d9%84%d8%ad%d8%b2%d9%85%d8%a9-%d8%a7%d9%84%d8%ae%d8%a7%d8%b5%d8%a9-%d9%a2\";}i:36;a:2:{s:2:\"id\";i:1151;s:5:\"title\";s:16:\"products-compare\";}}s:11:\"attachments\";a:51:{i:0;a:2:{s:2:\"id\";i:44;s:5:\"title\";s:10:\"overall_bg\";}i:1;a:2:{s:2:\"id\";i:79;s:5:\"title\";s:15:\"bitcoin-on-home\";}i:2;a:2:{s:2:\"id\";i:84;s:5:\"title\";s:5:\"logo2\";}i:3;a:2:{s:2:\"id\";i:102;s:5:\"title\";s:8:\"bitcoin_\";}i:4;a:2:{s:2:\"id\";i:110;s:5:\"title\";s:14:\"bitcoin_dollar\";}i:5;a:2:{s:2:\"id\";i:111;s:5:\"title\";s:3:\"fl1\";}i:6;a:2:{s:2:\"id\";i:112;s:5:\"title\";s:18:\"bitcoin_blockchain\";}i:7;a:2:{s:2:\"id\";i:113;s:5:\"title\";s:3:\"fl2\";}i:8;a:2:{s:2:\"id\";i:114;s:5:\"title\";s:16:\"bitcoin_investin\";}i:9;a:2:{s:2:\"id\";i:115;s:5:\"title\";s:3:\"fl3\";}i:10;a:2:{s:2:\"id\";i:118;s:5:\"title\";s:2:\"v1\";}i:11;a:2:{s:2:\"id\";i:119;s:5:\"title\";s:2:\"v2\";}i:12;a:2:{s:2:\"id\";i:124;s:5:\"title\";s:13:\"bitcoin_small\";}i:13;a:2:{s:2:\"id\";i:139;s:5:\"title\";s:2:\"p1\";}i:14;a:2:{s:2:\"id\";i:146;s:5:\"title\";s:2:\"p2\";}i:15;a:2:{s:2:\"id\";i:151;s:5:\"title\";s:2:\"p3\";}i:16;a:2:{s:2:\"id\";i:156;s:5:\"title\";s:2:\"p4\";}i:17;a:2:{s:2:\"id\";i:161;s:5:\"title\";s:2:\"p5\";}i:18;a:2:{s:2:\"id\";i:166;s:5:\"title\";s:2:\"p6\";}i:19;a:2:{s:2:\"id\";i:807;s:5:\"title\";s:32:\"87b208cd9eb4c4aceb5d65af190f2460\";}i:20;a:2:{s:2:\"id\";i:176;s:5:\"title\";s:5:\"cards\";}i:21;a:2:{s:2:\"id\";i:186;s:5:\"title\";s:9:\"client1-1\";}i:22;a:2:{s:2:\"id\";i:187;s:5:\"title\";s:9:\"client2-1\";}i:23;a:2:{s:2:\"id\";i:564;s:5:\"title\";s:48:\"bitcoin-mining-devices-standing-in-a-row-p2klve8\";}i:24;a:2:{s:2:\"id\";i:565;s:5:\"title\";s:7:\"crypto1\";}i:25;a:2:{s:2:\"id\";i:568;s:5:\"title\";s:7:\"crypto2\";}i:26;a:2:{s:2:\"id\";i:569;s:5:\"title\";s:7:\"crypto3\";}i:27;a:2:{s:2:\"id\";i:570;s:5:\"title\";s:7:\"crypto4\";}i:28;a:2:{s:2:\"id\";i:571;s:5:\"title\";s:7:\"crypto5\";}i:29;a:2:{s:2:\"id\";i:572;s:5:\"title\";s:7:\"crypto6\";}i:30;a:2:{s:2:\"id\";i:598;s:5:\"title\";s:2:\"v2\";}i:31;a:2:{s:2:\"id\";i:599;s:5:\"title\";s:3:\"v22\";}i:32;a:2:{s:2:\"id\";i:618;s:5:\"title\";s:2:\"a1\";}i:33;a:2:{s:2:\"id\";i:621;s:5:\"title\";s:3:\"aa2\";}i:34;a:2:{s:2:\"id\";i:657;s:5:\"title\";s:23:\"woocommerce-placeholder\";}i:35;a:2:{s:2:\"id\";i:778;s:5:\"title\";s:5:\"pr5-2\";}i:36;a:2:{s:2:\"id\";i:779;s:5:\"title\";s:3:\"pr5\";}i:37;a:2:{s:2:\"id\";i:780;s:5:\"title\";s:3:\"pr2\";}i:38;a:2:{s:2:\"id\";i:781;s:5:\"title\";s:3:\"pr4\";}i:39;a:2:{s:2:\"id\";i:782;s:5:\"title\";s:3:\"pr1\";}i:40;a:2:{s:2:\"id\";i:783;s:5:\"title\";s:3:\"pr3\";}i:41;a:2:{s:2:\"id\";i:784;s:5:\"title\";s:3:\"pr2\";}i:42;a:2:{s:2:\"id\";i:785;s:5:\"title\";s:3:\"pr7\";}i:43;a:2:{s:2:\"id\";i:786;s:5:\"title\";s:5:\"pr7-2\";}i:44;a:2:{s:2:\"id\";i:787;s:5:\"title\";s:5:\"pr7-3\";}i:45;a:2:{s:2:\"id\";i:788;s:5:\"title\";s:3:\"pr6\";}i:46;a:2:{s:2:\"id\";i:789;s:5:\"title\";s:5:\"pr8-2\";}i:47;a:2:{s:2:\"id\";i:790;s:5:\"title\";s:3:\"pr8\";}i:48;a:2:{s:2:\"id\";i:828;s:5:\"title\";s:6:\"crypto\";}i:49;a:2:{s:2:\"id\";i:1120;s:5:\"title\";s:3:\"dot\";}i:50;a:2:{s:2:\"id\";i:657;s:5:\"title\";s:23:\"woocommerce-placeholder\";}}s:7:\"sliders\";a:1:{i:0;a:1:{i:0;i:1;}}}","yes"),
("482","wp_calendar_block_has_published_posts","1","yes"),
("524","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:19:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:19:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:19:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:19:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:19:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:19:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:19:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:19:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:19:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:19:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:19:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:19:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:19:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:19:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:19:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:19:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:19:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:19:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:19:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:19:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:19:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:19:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:19:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:19:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:19:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:19:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:19:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:19:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:19:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:19:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:19:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:19:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:19:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:19:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:19:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:19:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:19:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:19:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:19:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:19:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:19:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:19:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:19:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:19:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:19:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:19:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:19:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:19:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:19:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:19:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:19:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:19:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:19:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:19:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:19:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:19:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:19:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:19:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:19:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:19:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:19:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:19:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:19:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:19:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:19:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:19:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:19:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:19:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:19:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:19:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:19:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:19:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:19:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:19:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:19:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:19:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:19:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:19:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:19:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:19:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:19:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:19:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:19:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:19:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:19:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:19:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:19:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:19:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:19:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:19:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:19:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:19:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:19:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:19:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:19:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:19:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:19:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:19:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:19:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:19:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:19:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:19:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:19:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:19:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:19:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:19:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:19:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:19:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:19:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:19:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:19:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:19:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:19:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:19:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:19:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:19:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:19:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:19:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:19:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:19:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:19:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:19:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:19:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:19:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:19:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:19:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:19:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:19:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:19:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:19:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:19:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:19:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:19:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:19:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:19:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:19:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:19:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:19:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:19:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:19:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:19:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:19:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:19:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:19:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:19:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:19:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:19:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:19:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:19:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:19:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:19:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:19:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:19:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:19:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:19:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:19:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:19:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:19:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:19:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:19:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:19:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:19:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:19:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:19:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:19:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:19:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:19:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\